from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JFAPOutboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'JFAPOutboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJFAPOutboundChannel");
  exportedObject.put("roleName", "WebSphereJFAPOutboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapoutboundchannel.name", objid, "name","JFAPOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapoutboundchannel.heartbeattimeout", objid, "heartbeatTimeout","JFAPOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapoutboundchannel.heartbeatinterval", objid, "heartbeatInterval","JFAPOutboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JFAPOutboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JFAPOutboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JFAPOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("JFAPOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jfapoutboundchannel.name", None));
  Util.addIfNotNone(properties, "heartbeatTimeout", roleProperties.optString("websphere.jfapoutboundchannel.heartbeattimeout", None));
  Util.addIfNotNone(properties, "heartbeatInterval", roleProperties.optString("websphere.jfapoutboundchannel.heartbeatinterval", None));
  print "Creating JFAPOutboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JFAPOutboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JFAPOutboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JFAPOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("JFAPOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapoutboundchannel.name", None), "name","JFAPOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapoutboundchannel.heartbeattimeout", None), "heartbeatTimeout","JFAPOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapoutboundchannel.heartbeatinterval", None), "heartbeatInterval","JFAPOutboundChannel");
  if len(atts) != 0:
    print "Modifying JFAPOutboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JFAPOutboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"JFAPOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JFAPOutboundChannel');
