from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LooseModule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLooseModule");
  exportedObject.put("roleName", "WebSphereLooseModule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.archiveversion", objid, "archiveVersion","LooseModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.archivetype", objid, "archiveType","LooseModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.uri", objid, "uri","LooseModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.binariespath", objid, "binariesPath","LooseModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.resourcespath", objid, "resourcesPath","LooseModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.otherarchivetype", objid, "otherArchiveType","LooseModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosemodule.altdd", objid, "altDD","LooseModule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"LooseModule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LooseModule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LooseModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "archiveVersion", roleProperties.optString("websphere.loosemodule.archiveversion", ""));
  Util.addIfNotNone(properties, "archiveType", roleProperties.optString("websphere.loosemodule.archivetype", "OTHER"));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.loosemodule.uri", None));
  Util.addIfNotNone(properties, "binariesPath", roleProperties.optString("websphere.loosemodule.binariespath", None));
  Util.addIfNotNone(properties, "resourcesPath", roleProperties.optString("websphere.loosemodule.resourcespath", None));
  Util.addIfNotNone(properties, "otherArchiveType", roleProperties.optString("websphere.loosemodule.otherarchivetype", ""));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.loosemodule.altdd", None));
  print "Creating LooseModule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LooseModule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseModule');

def update(objid,jsonobject):
  Util.pushPathElement('LooseModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.archiveversion", ""), "archiveVersion","LooseModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.archivetype", "OTHER"), "archiveType","LooseModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.uri", None), "uri","LooseModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.binariespath", None), "binariesPath","LooseModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.resourcespath", None), "resourcesPath","LooseModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.otherarchivetype", ""), "otherArchiveType","LooseModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosemodule.altdd", None), "altDD","LooseModule");
  if len(atts) != 0:
    print "Modifying LooseModule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LooseModule configuration up to date.";

  Property.removeProperties(objid, 'properties',"LooseModule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseModule');
