from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSInboundPort')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSInboundPort");
  exportedObject.put("roleName", "WebSphereSIBWSInboundPort");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.name", objid, "name","SIBWSInboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.securityinboundconfigname", objid, "securityInboundConfigName","SIBWSInboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.securityresponsegeneratorbindingconfigname", objid, "securityResponseGeneratorBindingConfigName","SIBWSInboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.jaxrpchandlerlistname", objid, "JAXRPCHandlerListName","SIBWSInboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.securityrequestconsumerbindingconfigname", objid, "securityRequestConsumerBindingConfigName","SIBWSInboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.description", objid, "description","SIBWSInboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsinboundport.templateportname", objid, "templatePortName","SIBWSInboundPort");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"SIBWSInboundPort");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSInboundPort');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSInboundPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSInboundPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwsinboundport.name", None));
  Util.addIfNotNone(properties, "securityInboundConfigName", roleProperties.optString("websphere.sibwsinboundport.securityinboundconfigname", None));
  Util.addIfNotNone(properties, "securityResponseGeneratorBindingConfigName", roleProperties.optString("websphere.sibwsinboundport.securityresponsegeneratorbindingconfigname", None));
  Util.addIfNotNone(properties, "JAXRPCHandlerListName", roleProperties.optString("websphere.sibwsinboundport.jaxrpchandlerlistname", None));
  Util.addIfNotNone(properties, "securityRequestConsumerBindingConfigName", roleProperties.optString("websphere.sibwsinboundport.securityrequestconsumerbindingconfigname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibwsinboundport.description", None));
  Util.addIfNotNone(properties, "templatePortName", roleProperties.optString("websphere.sibwsinboundport.templateportname", None));
  print "Creating SIBWSInboundPort with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSInboundPort", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSInboundPort');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSInboundPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSInboundPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.name", None), "name","SIBWSInboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.securityinboundconfigname", None), "securityInboundConfigName","SIBWSInboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.securityresponsegeneratorbindingconfigname", None), "securityResponseGeneratorBindingConfigName","SIBWSInboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.jaxrpchandlerlistname", None), "JAXRPCHandlerListName","SIBWSInboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.securityrequestconsumerbindingconfigname", None), "securityRequestConsumerBindingConfigName","SIBWSInboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.description", None), "description","SIBWSInboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsinboundport.templateportname", None), "templatePortName","SIBWSInboundPort");
  if len(atts) != 0:
    print "Modifying SIBWSInboundPort with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSInboundPort configuration up to date.";

  Property.removeProperties(objid, 'property',"SIBWSInboundPort");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSInboundPort');
