from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSOutboundPort')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSOutboundPort");
  exportedObject.put("roleName", "WebSphereSIBWSOutboundPort");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.authenticatingproxyauthalias", objid, "authenticatingProxyAuthAlias","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.name", objid, "name","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.securityrequestgeneratorbindingconfigname", objid, "securityRequestGeneratorBindingConfigName","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.authenticatingproxyportnumber", objid, "authenticatingProxyPortNumber","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.jaxrpchandlerlistname", objid, "JAXRPCHandlerListName","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.retargettedbindingnamespace", objid, "retargettedBindingNamespace","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.securityoutboundconfigname", objid, "securityOutboundConfigName","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.authenticatingproxyhostname", objid, "authenticatingProxyHostName","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.portdestinationname", objid, "portDestinationName","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.description", objid, "description","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.securityresponseconsumerbindingconfigname", objid, "securityResponseConsumerBindingConfigName","SIBWSOutboundPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundport.retargetteduri", objid, "retargettedURI","SIBWSOutboundPort");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"SIBWSOutboundPort");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSOutboundPort');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSOutboundPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSOutboundPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "authenticatingProxyAuthAlias", roleProperties.optString("websphere.sibwsoutboundport.authenticatingproxyauthalias", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwsoutboundport.name", None));
  Util.addIfNotNone(properties, "securityRequestGeneratorBindingConfigName", roleProperties.optString("websphere.sibwsoutboundport.securityrequestgeneratorbindingconfigname", None));
  Util.addIfNotNone(properties, "authenticatingProxyPortNumber", roleProperties.optString("websphere.sibwsoutboundport.authenticatingproxyportnumber", None));
  Util.addIfNotNone(properties, "JAXRPCHandlerListName", roleProperties.optString("websphere.sibwsoutboundport.jaxrpchandlerlistname", None));
  Util.addIfNotNone(properties, "retargettedBindingNamespace", roleProperties.optString("websphere.sibwsoutboundport.retargettedbindingnamespace", None));
  Util.addIfNotNone(properties, "securityOutboundConfigName", roleProperties.optString("websphere.sibwsoutboundport.securityoutboundconfigname", None));
  Util.addIfNotNone(properties, "authenticatingProxyHostName", roleProperties.optString("websphere.sibwsoutboundport.authenticatingproxyhostname", None));
  Util.addIfNotNone(properties, "portDestinationName", roleProperties.optString("websphere.sibwsoutboundport.portdestinationname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibwsoutboundport.description", None));
  Util.addIfNotNone(properties, "securityResponseConsumerBindingConfigName", roleProperties.optString("websphere.sibwsoutboundport.securityresponseconsumerbindingconfigname", None));
  Util.addIfNotNone(properties, "retargettedURI", roleProperties.optString("websphere.sibwsoutboundport.retargetteduri", None));
  print "Creating SIBWSOutboundPort with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSOutboundPort", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSOutboundPort');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSOutboundPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSOutboundPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.authenticatingproxyauthalias", None), "authenticatingProxyAuthAlias","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.name", None), "name","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.securityrequestgeneratorbindingconfigname", None), "securityRequestGeneratorBindingConfigName","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.authenticatingproxyportnumber", None), "authenticatingProxyPortNumber","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.jaxrpchandlerlistname", None), "JAXRPCHandlerListName","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.retargettedbindingnamespace", None), "retargettedBindingNamespace","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.securityoutboundconfigname", None), "securityOutboundConfigName","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.authenticatingproxyhostname", None), "authenticatingProxyHostName","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.portdestinationname", None), "portDestinationName","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.description", None), "description","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.securityresponseconsumerbindingconfigname", None), "securityResponseConsumerBindingConfigName","SIBWSOutboundPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundport.retargetteduri", None), "retargettedURI","SIBWSOutboundPort");
  if len(atts) != 0:
    print "Modifying SIBWSOutboundPort with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSOutboundPort configuration up to date.";

  Property.removeProperties(objid, 'property',"SIBWSOutboundPort");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSOutboundPort');
