from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TargetMembership')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTargetMembership");
  exportedObject.put("roleName", "WebSphereTargetMembership");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.targetmembership.memberstring", objid, "memberString","TargetMembership");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.targetmembership.type", objid, "type","TargetMembership");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TargetMembership');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TargetMembership')
  if not jsonobject.has("roleProperties"):
    raise Exception("TargetMembership resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "memberString", roleProperties.optString("websphere.targetmembership.memberstring", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.targetmembership.type", None));
  print "Creating TargetMembership with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TargetMembership", parentid, properties);
  Util.popPathElement('TargetMembership');

def update(objid,jsonobject):
  Util.pushPathElement('TargetMembership')
  if not jsonobject.has("roleProperties"):
    raise Exception("TargetMembership resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.targetmembership.memberstring", None), "memberString","TargetMembership");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.targetmembership.type", None), "type","TargetMembership");
  if len(atts) != 0:
    print "Modifying TargetMembership with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TargetMembership configuration up to date.";

  Util.popPathElement('TargetMembership');
