from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Timers')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTimers");
  exportedObject.put("roleName", "WebSphereTimers");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerk", objid, "timerK","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerj", objid, "timerJ","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timeri", objid, "timerI","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerh", objid, "timerH","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerg", objid, "timerG","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerf", objid, "timerF","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timere", objid, "timerE","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerd", objid, "timerD","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timerb", objid, "timerB","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timera", objid, "timerA","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timert4", objid, "timerT4","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timert2", objid, "timerT2","Timers");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timers.timert1", objid, "timerT1","Timers");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Timers');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Timers')
  if not jsonobject.has("roleProperties"):
    raise Exception("Timers resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "timerK", roleProperties.optString("websphere.timers.timerk", None));
  Util.addIfNotNone(properties, "timerJ", roleProperties.optString("websphere.timers.timerj", None));
  Util.addIfNotNone(properties, "timerI", roleProperties.optString("websphere.timers.timeri", None));
  Util.addIfNotNone(properties, "timerH", roleProperties.optString("websphere.timers.timerh", None));
  Util.addIfNotNone(properties, "timerG", roleProperties.optString("websphere.timers.timerg", None));
  Util.addIfNotNone(properties, "timerF", roleProperties.optString("websphere.timers.timerf", None));
  Util.addIfNotNone(properties, "timerE", roleProperties.optString("websphere.timers.timere", None));
  Util.addIfNotNone(properties, "timerD", roleProperties.optString("websphere.timers.timerd", None));
  Util.addIfNotNone(properties, "timerB", roleProperties.optString("websphere.timers.timerb", None));
  Util.addIfNotNone(properties, "timerA", roleProperties.optString("websphere.timers.timera", None));
  Util.addIfNotNone(properties, "timerT4", roleProperties.optString("websphere.timers.timert4", None));
  Util.addIfNotNone(properties, "timerT2", roleProperties.optString("websphere.timers.timert2", None));
  Util.addIfNotNone(properties, "timerT1", roleProperties.optString("websphere.timers.timert1", None));
  print "Creating Timers with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Timers", parentid, properties);
  Util.popPathElement('Timers');

def update(objid,jsonobject):
  Util.pushPathElement('Timers')
  if not jsonobject.has("roleProperties"):
    raise Exception("Timers resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerk", None), "timerK","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerj", None), "timerJ","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timeri", None), "timerI","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerh", None), "timerH","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerg", None), "timerG","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerf", None), "timerF","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timere", None), "timerE","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerd", None), "timerD","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timerb", None), "timerB","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timera", None), "timerA","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timert4", None), "timerT4","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timert2", None), "timerT2","Timers");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timers.timert1", None), "timerT1","Timers");
  if len(atts) != 0:
    print "Modifying Timers with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Timers configuration up to date.";

  Util.popPathElement('Timers');
