from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASBasicAuthData')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASBasicAuthData");
  exportedObject.put("roleName", "WebSphereWASBasicAuthData");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasbasicauthdata.password", objid, "password","WASBasicAuthData");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasbasicauthdata.userid", objid, "userId","WASBasicAuthData");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASBasicAuthData');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASBasicAuthData')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASBasicAuthData resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.wasbasicauthdata.password", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.wasbasicauthdata.userid", None));
  print "Creating WASBasicAuthData with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASBasicAuthData", parentid, properties);
  Util.popPathElement('WASBasicAuthData');

def update(objid,jsonobject):
  Util.pushPathElement('WASBasicAuthData')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASBasicAuthData resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasbasicauthdata.password", None), "password","WASBasicAuthData");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasbasicauthdata.userid", None), "userId","WASBasicAuthData");
  if len(atts) != 0:
    print "Modifying WASBasicAuthData with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASBasicAuthData configuration up to date.";

  Util.popPathElement('WASBasicAuthData');
