from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from LibraryRef import LibraryRef
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Classloader')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClassloader");
  exportedObject.put("roleName", "WebSphereClassloader");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.classloader.mode", objid, "mode","Classloader");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  libraryRefs = Util.parseConfigIdListAttribute(objid, 'libraries', "Classloader");
  for libraryRef in libraryRefs:
    if len(libraryRef) > 0:
      returndict = Util.createTypeFolder(respath, "LibraryRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, LibraryRef._export(libraryRef, currespath, "LibraryRef%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Classloader');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Classloader')
  if not jsonobject.has("roleProperties"):
    raise Exception("Classloader resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "mode", roleProperties.optString("websphere.classloader.mode", None));
  print "Creating Classloader with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Classloader", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereLibraryRef":
        LibraryRef.create(objid, curjsonobject);
  Util.popPathElement('Classloader');

def update(objid,jsonobject):
  Util.pushPathElement('Classloader')
  if not jsonobject.has("roleProperties"):
    raise Exception("Classloader resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.classloader.mode", None), "mode","Classloader");
  if len(atts) != 0:
    print "Modifying Classloader with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Classloader configuration up to date.";

  libraryRefs = Util.parseConfigIdListAttribute(objid, 'libraries', "Classloader");
  for libraryRef in libraryRefs:
    Util.remove(libraryRef);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereLibraryRef":
        LibraryRef.create(objid, curjsonobject);
  Util.popPathElement('Classloader');
