from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from Property import Property
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ForeignServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereForeignServer");
  exportedObject.put("roleName", "WebSphereForeignServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.foreignserver.name", objid, "name","ForeignServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.foreignserver.overridetype", objid, "overrideType","ForeignServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ForeignServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "ForeignServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "ForeignServer");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ForeignServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ForeignServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ForeignServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("ForeignServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.foreignserver.name", None));
  Util.addIfNotNone(properties, "overrideType", roleProperties.optString("websphere.foreignserver.overridetype", None));
  print "Creating ForeignServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ForeignServer", parentid, properties);

  Property.removeProperties(objid, 'properties',"ForeignServer");
  Component.removeComponents(objid, 'components', "ForeignServer");
  Service.removeServices(objid, 'services', "ForeignServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ForeignServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('ForeignServer');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ForeignServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("ForeignServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.foreignserver.name", None), "name","ForeignServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.foreignserver.overridetype", None), "overrideType","ForeignServer");
  if len(atts) != 0:
    print "Modifying ForeignServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ForeignServer configuration up to date.";

  Property.removeProperties(objid, 'properties',"ForeignServer");
  Component.removeComponents(objid, 'components', "ForeignServer");
  Service.removeServices(objid, 'services', "ForeignServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ForeignServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);       
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('ForeignServer');
