from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMIRMFilter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMIRMFilter");
  exportedObject.put("roleName", "WebSpherePMIRMFilter");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirmfilter.extendedtype", objid, "extendedType","PMIRMFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirmfilter.enable", objid, "enable","PMIRMFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirmfilter.type", objid, "type","PMIRMFilter");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMIRMFilter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PMIRMFilter')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIRMFilter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "extendedType", roleProperties.optString("websphere.pmirmfilter.extendedtype", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.pmirmfilter.enable", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.pmirmfilter.type", None));
  print "Creating PMIRMFilter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMIRMFilter", parentid, properties);
  Util.popPathElement('PMIRMFilter');

def update(objid,jsonobject):
  Util.pushPathElement('PMIRMFilter')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIRMFilter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirmfilter.extendedtype", None), "extendedType","PMIRMFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirmfilter.enable", None), "enable","PMIRMFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirmfilter.type", None), "type","PMIRMFilter");
  if len(atts) != 0:
    print "Modifying PMIRMFilter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PMIRMFilter configuration up to date.";

  Util.popPathElement('PMIRMFilter');
