from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SessionBeanConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSessionBeanConfig");
  exportedObject.put("roleName", "WebSphereSessionBeanConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sessionbeanconfig.ejbname", objid, "ejbName","SessionBeanConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SessionBeanConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SessionBeanConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionBeanConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "ejbName", roleProperties.optString("websphere.sessionbeanconfig.ejbname", None));
  print "Creating SessionBeanConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SessionBeanConfig", parentid, properties);
  Util.popPathElement('SessionBeanConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SessionBeanConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionBeanConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sessionbeanconfig.ejbname", None), "ejbName","SessionBeanConfig");
  if len(atts) != 0:
    print "Modifying SessionBeanConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SessionBeanConfig configuration up to date.";

  Util.popPathElement('SessionBeanConfig');
