from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('TrustManagerRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTrustManagerRef");
  exportedObject.put("roleName", "WebSphereTrustManagerRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanagerref.name", objid, "name", "TrustManager");
  
  scopeName = None;
  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'TrustManager');
  if managementScope is not None and len(managementScope) > 0:
    scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
    if scopeName is not None and len(scopeName) > 0:
      Util.addToJsonIfNotNone(roleProperties, "websphere.trustmanagerref.scopename", scopeName);
  
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TrustManagerRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('TrustManagerRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustManagerRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.trustmanagerref.name'):
    raise Exception("TrustManagerRef resource has no property named websphere.trustmanagerref.name!");
  if not roleProperties.has('websphere.trustmanagerref.scopename'):
    raise Exception("TrustManagerRef resource has no property named websphere.trustmanagerref.scopename!");

  trustManagerName = roleProperties.getString('websphere.trustmanagerref.name');
  trustManagerScopeName = roleProperties.getString('websphere.trustmanagerref.scopename');

  trustManagerId = None;
  trustManagers = Util.getid("/TrustManager:/").splitlines();
  if len(trustManagers) > 0:
    for trustManager in trustManagers:
      if len(trustManager) > 0:
        name = Util.getRequiredAttribute(trustManager, "name", "TrustManager" );
        scopeName = None;
        managementScope = Util.getOptionalAttribute(trustManager, 'managementScope', 'TrustManager');
        if managementScope is not None and len(managementScope) > 0:
          scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
        if (trustManagerName == name and trustManagerScopeName == scopeName):
          trustManagerId = trustManager;
          break;
  
  if trustManagerId is None or len(trustManagerId) < 1:
    raise Exception("Could not find TrustManager named %(name)s with management scopename of %(scopeName)s" % { 'name':trustManagerName, 'scopeName':trustManagerScopeName } );

  properties = [];
  properties.append([parentAtt, trustManagerId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating TrustManagerRef to %(id)s for attribute %(att)s" % { 'id':trustManagerId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating TrustManagerRef to %(id)s for attribute %(att)s" % { 'id':trustManagerId, 'att':parentAtt });
  Util.popPathElement('TrustManagerRef');
