from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DiscretionaryGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDiscretionaryGoal");
  exportedObject.put("roleName", "WebSphereDiscretionaryGoal");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discretionarygoal.importance", objid, "importance","DiscretionaryGoal");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DiscretionaryGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DiscretionaryGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("DiscretionaryGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "importance", roleProperties.optString("websphere.discretionarygoal.importance", None));
  print "Creating DiscretionaryGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DiscretionaryGoal", parentid, properties);
  Util.popPathElement('DiscretionaryGoal');

def update(objid,jsonobject):
  Util.pushPathElement('DiscretionaryGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("DiscretionaryGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discretionarygoal.importance", None), "importance","DiscretionaryGoal");
  if len(atts) != 0:
    print "Modifying DiscretionaryGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DiscretionaryGoal configuration up to date.";

  Util.popPathElement('DiscretionaryGoal');
