from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EndPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEndPoint");
  exportedObject.put("roleName", "WebSphereEndPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.endpoint.port", objid, "port","EndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.endpoint.host", objid, "host","EndPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EndPoint');
  return result;



def create(parentid, jsonobject, attribute = ""):
  Util.pushPathElement('EndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("EndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.endpoint.port", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.endpoint.host", None));
  print "Creating EndPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EndPoint", parentid, properties, attribute);
  Util.popPathElement('EndPoint');

def update(objid,jsonobject):
  Util.pushPathElement('EndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("EndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.endpoint.port", None), "port","EndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.endpoint.host", None), "host","EndPoint");
  if len(atts) != 0:
    print "Modifying EndPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EndPoint configuration up to date.";

  Util.popPathElement('EndPoint');
