from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('KeyManagerRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereKeyManagerRef");
  exportedObject.put("roleName", "WebSphereKeyManagerRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keymanagerref.name", objid, "name","KeyManager");
  
  scopeName = None;
  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'KeyManager');
  if managementScope is not None and len(managementScope) > 0:
    scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
    if scopeName is not None and len(scopeName) > 0:
      Util.addToJsonIfNotNone(roleProperties, "websphere.keymanagerref.scopename", scopeName);
  
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('KeyManagerRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('KeyManagerRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyManagerRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.keymanagerref.name'):
    raise Exception("KeyManagerRef resource has no property named websphere.keymanagerref.name!");
  if not roleProperties.has('websphere.keymanagerref.scopename'):
    raise Exception("KeyManagerRef resource has no property named websphere.keymanagerref.scopename!");

  keyManagerName = roleProperties.getString('websphere.keymanagerref.name');
  keyManagerScopeName = roleProperties.getString('websphere.keymanagerref.scopename');

  keyManagerId = None;
  keyManagers = Util.getid("/KeyManager:/").splitlines();
  if len(keyManagers) > 0:
    for keyManager in keyManagers:
      if len(keyManager) > 0:
        name = Util.getRequiredAttribute(keyManager, "name", "KeyManager" );
        scopeName = None;
        managementScope = Util.getOptionalAttribute(keyManager, 'managementScope', 'KeyManager');
        if managementScope is not None and len(managementScope) > 0:
          scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
        
        if (keyManagerName == name and keyManagerScopeName == scopeName):
          keyManagerId = keyManager;
          break;
  
  if keyManagerId is None or len(keyManagerId) < 1:
    raise Exception("Could not find keymanager named %(name)s with management scopename of %(scopeName)s" % { 'name':keyManagerName, 'scopeName':keyManagerScopeName } );

  properties = [];
  properties.append([parentAtt, keyManagerId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating KeyManagerRef to %(id)s for attribute %(att)s" % { 'id':keyManagerId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating KeyManagerRef to %(id)s for attribute %(att)s" % { 'id':keyManagerId, 'att':parentAtt });
  Util.popPathElement('KeyManagerRef');
