from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBJMSConnectionFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBJMSConnectionFactory");
  exportedObject.put("roleName", "WebSphereSIBJMSConnectionFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.password", objid, "password","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.readahead", objid, "readAhead","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.tempqueuemodelname", objid, "tempQueueModelName","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.portnumber", objid, "portNumber","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.providertype", objid, "providerType","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.durablesubscriptionhome", objid, "durableSubscriptionHome","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.servername", objid, "serverName","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.username", objid, "userName","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.nonpersistentmapping", objid, "nonPersistentMapping","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.jndiname", objid, "jndiName","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.menames", objid, "meNames","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.category", objid, "category","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.busname", objid, "busName","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.description", objid, "description","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.temptopicmodelname", objid, "tempTopicModelName","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.clientid", objid, "clientId","SIBJMSConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsconnectionfactory.name", objid, "name","SIBJMSConnectionFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBJMSConnectionFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBJMSConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.sibjmsconnectionfactory.password", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.sibjmsconnectionfactory.readahead", None));
  Util.addIfNotNone(properties, "tempQueueModelName", roleProperties.optString("websphere.sibjmsconnectionfactory.tempqueuemodelname", None));
  Util.addIfNotNone(properties, "portNumber", roleProperties.optString("websphere.sibjmsconnectionfactory.portnumber", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.sibjmsconnectionfactory.providertype", None));
  Util.addIfNotNone(properties, "durableSubscriptionHome", roleProperties.optString("websphere.sibjmsconnectionfactory.durablesubscriptionhome", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.sibjmsconnectionfactory.servername", None));
  Util.addIfNotNone(properties, "userName", roleProperties.optString("websphere.sibjmsconnectionfactory.username", None));
  Util.addIfNotNone(properties, "nonPersistentMapping", roleProperties.optString("websphere.sibjmsconnectionfactory.nonpersistentmapping", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.sibjmsconnectionfactory.jndiname", None));
  Util.addIfNotNone(properties, "meNames", roleProperties.optString("websphere.sibjmsconnectionfactory.menames", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.sibjmsconnectionfactory.category", None));
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibjmsconnectionfactory.busname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibjmsconnectionfactory.description", None));
  Util.addIfNotNone(properties, "tempTopicModelName", roleProperties.optString("websphere.sibjmsconnectionfactory.temptopicmodelname", None));
  Util.addIfNotNone(properties, "clientId", roleProperties.optString("websphere.sibjmsconnectionfactory.clientid", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibjmsconnectionfactory.name", None));
  print "Creating SIBJMSConnectionFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBJMSConnectionFactory", parentid, properties);
  Util.popPathElement('SIBJMSConnectionFactory');

def update(objid,jsonobject):
  Util.pushPathElement('SIBJMSConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.password", None), "password","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.readahead", None), "readAhead","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.tempqueuemodelname", None), "tempQueueModelName","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.portnumber", None), "portNumber","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.providertype", None), "providerType","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.durablesubscriptionhome", None), "durableSubscriptionHome","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.servername", None), "serverName","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.username", None), "userName","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.nonpersistentmapping", None), "nonPersistentMapping","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.jndiname", None), "jndiName","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.menames", None), "meNames","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.category", None), "category","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.busname", None), "busName","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.description", None), "description","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.temptopicmodelname", None), "tempTopicModelName","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.clientid", None), "clientId","SIBJMSConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsconnectionfactory.name", None), "name","SIBJMSConnectionFactory");
  if len(atts) != 0:
    print "Modifying SIBJMSConnectionFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBJMSConnectionFactory configuration up to date.";

  Util.popPathElement('SIBJMSConnectionFactory');
