from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TrustedAuthenticationRealm')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTrustedAuthenticationRealm");
  exportedObject.put("roleName", "WebSphereTrustedAuthenticationRealm");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustedauthenticationrealm.trustallrealms", objid, "trustAllRealms","TrustedAuthenticationRealm");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustedauthenticationrealm.realmlist", objid, "realmList","TrustedAuthenticationRealm");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TrustedAuthenticationRealm');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  return doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  tar = Util.getid(containmentpath);

  if tar == None or tar == "":
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      tar = create(parentid, jsonobject, 'inboundTrustedAuthenticationRealm');
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(tar);
      tar = None;
    else:
      update(tar, jsonobject);
  return tar;

def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('TrustedAuthenticationRealm')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustedAuthenticationRealm resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "trustAllRealms", roleProperties.optString("websphere.trustedauthenticationrealm.trustallrealms", None));
  Util.addIfNotNone(properties, "realmList", roleProperties.optString("websphere.trustedauthenticationrealm.realmlist", None));
  print "Creating TrustedAuthenticationRealm with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TrustedAuthenticationRealm", parentid, properties, attName);
  Util.popPathElement('TrustedAuthenticationRealm');

def update(objid,jsonobject):
  Util.pushPathElement('TrustedAuthenticationRealm')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustedAuthenticationRealm resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustedauthenticationrealm.trustallrealms", None), "trustAllRealms","TrustedAuthenticationRealm");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustedauthenticationrealm.realmlist", None), "realmList","TrustedAuthenticationRealm");
  if len(atts) != 0:
    print "Modifying TrustedAuthenticationRealm with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TrustedAuthenticationRealm configuration up to date.";

  Util.popPathElement('TrustedAuthenticationRealm');
