from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from Property import Property
from PluginProperties import PluginProperties
from utilities import Util
from StateManageable import StateManageable
from AdminServerAuthentication import AdminServerAuthentication

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WebServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWebServer");
  exportedObject.put("roleName", "WebSphereWebServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.webserverinstallroot", objid, "webserverInstallRoot","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.configurationfilename", objid, "configurationFilename","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.logfilenameerror", objid, "logFilenameError","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.webserveradminprotocol", objid, "webserverAdminProtocol","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.servicename", objid, "serviceName","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.webserverprotocol", objid, "webserverProtocol","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.logfilenameaccess", objid, "logFilenameAccess","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.webservertype", objid, "webserverType","WebServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserver.name", objid, "name","WebServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WebServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "WebServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "WebServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"WebServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));

  adminServerAuthentication = Util.getOptionalAttribute(objid, 'adminServerAuthentication',"WebServer");
  if adminServerAuthentication is not None and len(adminServerAuthentication) > 0:
    returndict = Util.createTypeFolder(respath, "AdminServerAuthentication", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, AdminServerAuthentication._export(adminServerAuthentication, currespath, "AdminServerAuthentication"));

  i = 0
  pluginProperties = Util.getRequiredAttribute(objid, 'pluginProperties',"WebServer");
  for pluginProp in pluginProperties[1:-1].split(","):
    if pluginProp is not None and len(pluginProp) > 0:
      returndict = Util.createTypeFolder(respath, "PluginProperties", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, PluginProperties._export(pluginProp, currespath, "PluginProperties%s" % i));
      i += 1

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WebServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WebServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "webserverInstallRoot", roleProperties.optString("websphere.webserver.webserverinstallroot", None));
  Util.addIfNotNone(properties, "configurationFilename", roleProperties.optString("websphere.webserver.configurationfilename", None));
  Util.addIfNotNone(properties, "logFilenameError", roleProperties.optString("websphere.webserver.logfilenameerror", None));
  Util.addIfNotNone(properties, "webserverAdminProtocol", roleProperties.optString("websphere.webserver.webserveradminprotocol", None));
  Util.addIfNotNone(properties, "serviceName", roleProperties.optString("websphere.webserver.servicename", None));
  Util.addIfNotNone(properties, "webserverProtocol", roleProperties.optString("websphere.webserver.webserverprotocol", None));
  Util.addIfNotNone(properties, "logFilenameAccess", roleProperties.optString("websphere.webserver.logfilenameaccess", None));
  Util.addIfNotNone(properties, "webserverType", roleProperties.optString("websphere.webserver.webservertype", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.webserver.name", None));
  print "Creating WebServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WebServer", parentid, properties);

  Property.removeProperties(objid, 'properties',"WebServer");
  Component.removeComponents(objid, 'components', "WebServer");
  Service.removeServices(objid, 'services', "WebServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"WebServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);

  adminServerAuthentication = Util.getOptionalAttribute(objid, 'adminServerAuthentication',"WebServer");
  if adminServerAuthentication is not None and len(adminServerAuthentication) > 0:
    Util.remove(adminServerAuthentication);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);
          if currole == "WebSphereAdminServerAuthentication":
            AdminServerAuthentication.create(objid, curjsonobject);
          if currole == "WebSpherePluginProperties":
            PluginProperties.create(objid, curjsonobject);

  Util.popPathElement('WebServer');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WebServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.webserverinstallroot", None), "webserverInstallRoot","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.configurationfilename", None), "configurationFilename","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.logfilenameerror", None), "logFilenameError","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.webserveradminprotocol", None), "webserverAdminProtocol","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.servicename", None), "serviceName","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.webserverprotocol", None), "webserverProtocol","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.logfilenameaccess", None), "logFilenameAccess","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.webservertype", None), "webserverType","WebServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserver.name", None), "name","WebServer");
  if len(atts) != 0:
    print "Modifying WebServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "WebServer configuration up to date.";

  Property.removeProperties(objid, 'properties',"WebServer");
  Component.removeComponents(objid, 'components', "WebServer");
  Service.removeServices(objid, 'services', "WebServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"WebServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);

  adminServerAuthentication = Util.getOptionalAttribute(objid, 'adminServerAuthentication',"WebServer");
  if adminServerAuthentication is not None and len(adminServerAuthentication) > 0:
    Util.remove(adminServerAuthentication);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);
          if currole == "WebSphereAdminServerAuthentication":
            AdminServerAuthentication.create(objid, curjsonobject);
          if currole == "WebSpherePluginProperties":
            PluginProperties.update(objid, curjsonobject);

  Util.popPathElement('WebServer');
