from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.workareapartition.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WorkAreaPartition');

  containmentpath = "%(parentconpath)sWorkAreaPartition:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WorkAreaPartition')

  name = Util.getRequiredAttribute(objid, "name", 'WorkAreaPartition');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkAreaPartition");
  exportedObject.put("roleName", "WebSphereWorkAreaPartition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.name", objid, "name","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.deferredattributeserialization", objid, "deferredAttributeSerialization","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.bidirectional", objid, "bidirectional","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.maxreceivesize", objid, "maxReceiveSize","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.enable", objid, "enable","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.maxsendsize", objid, "maxSendSize","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.enablewebservicepropagation", objid, "enableWebServicePropagation","WorkAreaPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartition.description", objid, "description","WorkAreaPartition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WorkAreaPartition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkAreaPartition');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaPartition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.workareapartition.name"):
    raise Exception("Resource role properties does not contain websphere.workareapartition.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create WorkAreaPartition on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkAreaPartition')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaPartition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workareapartition.name"):
    raise Exception("Resource role properties does not contain websphere.workareapartition.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.workareapartition.name", None));
  Util.addIfNotNone(properties, "deferredAttributeSerialization", roleProperties.optString("websphere.workareapartition.deferredattributeserialization", None));
  Util.addIfNotNone(properties, "bidirectional", roleProperties.optString("websphere.workareapartition.bidirectional", None));
  Util.addIfNotNone(properties, "maxReceiveSize", roleProperties.optString("websphere.workareapartition.maxreceivesize", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.workareapartition.enable", None));
  Util.addIfNotNone(properties, "maxSendSize", roleProperties.optString("websphere.workareapartition.maxsendsize", None));
  Util.addIfNotNone(properties, "enableWebServicePropagation", roleProperties.optString("websphere.workareapartition.enablewebservicepropagation", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.workareapartition.description", None));
  print "Creating WorkAreaPartition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkAreaPartition", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WorkAreaPartition');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WorkAreaPartition')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaPartition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workareapartition.name"):
    raise Exception("Resource role properties does not contain websphere.workareapartition.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.name", None), "name","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.deferredattributeserialization", None), "deferredAttributeSerialization","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.bidirectional", None), "bidirectional","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.maxreceivesize", None), "maxReceiveSize","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.enable", None), "enable","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.maxsendsize", None), "maxSendSize","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.enablewebservicepropagation", None), "enableWebServicePropagation","WorkAreaPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartition.description", None), "description","WorkAreaPartition");
  if len(atts) != 0:
    print "Modifying WorkAreaPartition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkAreaPartition configuration up to date.";

  Property.removeProperties(objid, 'properties',"WorkAreaPartition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('WorkAreaPartition');
