from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from WorkAreaPartition import WorkAreaPartition
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WorkAreaPartitionService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkAreaPartitionService");
  exportedObject.put("roleName", "WebSphereWorkAreaPartitionService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareapartitionservice.enable", objid, "enable","WorkAreaPartitionService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WorkAreaPartitionService");

  i = 0;
  partitions = Util.parseConfigIdListAttribute(objid, 'partitions',"WorkAreaPartitionService");
  for partition in partitions:
    if len(partition) > 0:
      returndict = Util.createTypeFolder(respath, "WorkAreaPartition", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, WorkAreaPartition._export(partition, currespath, "WorkAreaPartition%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkAreaPartitionService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WorkAreaPartitionService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaPartitionService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.workareapartitionservice.enable", None));
  print "Creating WorkAreaPartitionService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkAreaPartitionService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereWorkAreaPartition":
        WorkAreaPartition.create(objid, curjsonobject);
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WorkAreaPartitionService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WorkAreaPartitionService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaPartitionService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareapartitionservice.enable", None), "enable","WorkAreaPartitionService");
  if len(atts) != 0:
    print "Modifying WorkAreaPartitionService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkAreaPartitionService configuration up to date.";

  partitions = Util.parseConfigIdListAttribute(objid, 'partitions', "WorkAreaPartitionService");
  for partition in partitions:
    if len(partition) > 0:
      Util.remove(partition);

  Property.removeProperties(objid, 'properties',"WorkAreaPartitionService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereWorkAreaPartition":
        WorkAreaPartition.create(objid, curjsonobject);
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WorkAreaPartitionService');
