from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExternalDomain')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExternalDomain");
  exportedObject.put("roleName", "WebSphereExternalDomain");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externaldomain.port", objid, "port","ExternalDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externaldomain.domainname", objid, "domainName","ExternalDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externaldomain.host", objid, "host","ExternalDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externaldomain.distinguishedname", objid, "distinguishedName","ExternalDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externaldomain.protocol", objid, "protocol","ExternalDomain");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ExternalDomain");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExternalDomain');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ExternalDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.externaldomain.port", None));
  Util.addIfNotNone(properties, "domainName", roleProperties.optString("websphere.externaldomain.domainname", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.externaldomain.host", None));
  Util.addIfNotNone(properties, "distinguishedName", roleProperties.optString("websphere.externaldomain.distinguishedname", None));
  Util.addIfNotNone(properties, "protocol", roleProperties.optString("websphere.externaldomain.protocol", None));
  print "Creating ExternalDomain with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExternalDomain", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ExternalDomain');

def update(objid,jsonobject):
  Util.pushPathElement('ExternalDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externaldomain.port", None), "port","ExternalDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externaldomain.domainname", None), "domainName","ExternalDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externaldomain.host", None), "host","ExternalDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externaldomain.distinguishedname", None), "distinguishedName","ExternalDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externaldomain.protocol", None), "protocol","ExternalDomain");
  if len(atts) != 0:
    print "Modifying ExternalDomain with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExternalDomain configuration up to date.";

  Property.removeProperties(objid, 'properties',"ExternalDomain");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ExternalDomain');
