from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MemoryCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMemoryCondition");
  exportedObject.put("roleName", "WebSphereMemoryCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memorycondition.timeunits", objid, "timeUnits","MemoryCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memorycondition.timeoverthreshold", objid, "timeOverThreshold","MemoryCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memorycondition.name", objid, "name","MemoryCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memorycondition.memoryused", objid, "memoryUsed","MemoryCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memorycondition.conditionexpr", objid, "conditionExpr","MemoryCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MemoryCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MemoryCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("MemoryCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "timeUnits", roleProperties.optString("websphere.memorycondition.timeunits", None));
  Util.addIfNotNone(properties, "timeOverThreshold", roleProperties.optString("websphere.memorycondition.timeoverthreshold", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.memorycondition.name", None));
  Util.addIfNotNone(properties, "memoryUsed", roleProperties.optString("websphere.memorycondition.memoryused", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.memorycondition.conditionexpr", None));
  print "Creating MemoryCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MemoryCondition", parentid, properties);
  Util.popPathElement('MemoryCondition');

def update(objid,jsonobject):
  Util.pushPathElement('MemoryCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("MemoryCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memorycondition.timeunits", None), "timeUnits","MemoryCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memorycondition.timeoverthreshold", None), "timeOverThreshold","MemoryCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memorycondition.name", None), "name","MemoryCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memorycondition.memoryused", None), "memoryUsed","MemoryCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memorycondition.conditionexpr", None), "conditionExpr","MemoryCondition");
  if len(atts) != 0:
    print "Modifying MemoryCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MemoryCondition configuration up to date.";

  Util.popPathElement('MemoryCondition');

def getMemoryCondition(objid):
  memoryCondition = Util.getAssociatedObjects(objid, "MemoryCondition");
  return memoryCondition;
