from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Application')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplication");
  exportedObject.put("roleName", "WebSphereApplication");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.application.displayname", objid, "displayName","Application");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.application.largeicon", objid, "largeIcon","Application");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.application.smallicon", objid, "smallIcon","Application");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.application.description", objid, "description","Application");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Application');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Application')
  if not jsonobject.has("roleProperties"):
    raise Exception("Application resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "displayName", roleProperties.optString("websphere.application.displayname", None));
  Util.addIfNotNone(properties, "largeIcon", roleProperties.optString("websphere.application.largeicon", None));
  Util.addIfNotNone(properties, "smallIcon", roleProperties.optString("websphere.application.smallicon", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.application.description", None));
  print "Creating Application with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Application", parentid, properties);
  Util.popPathElement('Application');

def update(objid,jsonobject):
  Util.pushPathElement('Application')
  if not jsonobject.has("roleProperties"):
    raise Exception("Application resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.application.displayname", None), "displayName","Application");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.application.largeicon", None), "largeIcon","Application");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.application.smallicon", None), "smallIcon","Application");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.application.description", None), "description","Application");
  if len(atts) != 0:
    print "Modifying Application with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Application configuration up to date.";

  Util.popPathElement('Application');
