from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConfigSynchronizationService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConfigSynchronizationService");
  exportedObject.put("roleName", "WebSphereConfigSynchronizationService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configsynchronizationservice.synchinterval", objid, "synchInterval","ConfigSynchronizationService");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.configsynchronizationservice.exclusions", objid, "exclusions","ConfigSynchronizationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configsynchronizationservice.enable", objid, "enable","ConfigSynchronizationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configsynchronizationservice.synchonserverstartup", objid, "synchOnServerStartup","ConfigSynchronizationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configsynchronizationservice.autosynchenabled", objid, "autoSynchEnabled","ConfigSynchronizationService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ConfigSynchronizationService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConfigSynchronizationService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ConfigSynchronizationService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConfigSynchronizationService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "synchInterval", roleProperties.optString("websphere.configsynchronizationservice.synchinterval", None));
  Util.addPathProperty(properties, "exclusions", roleProperties.optString("websphere.configsynchronizationservice.exclusions", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.configsynchronizationservice.enable", None));
  Util.addIfNotNone(properties, "synchOnServerStartup", roleProperties.optString("websphere.configsynchronizationservice.synchonserverstartup", None));
  Util.addIfNotNone(properties, "autoSynchEnabled", roleProperties.optString("websphere.configsynchronizationservice.autosynchenabled", None));
  print "Creating ConfigSynchronizationService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ConfigSynchronizationService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ConfigSynchronizationService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ConfigSynchronizationService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConfigSynchronizationService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configsynchronizationservice.synchinterval", None), "synchInterval","ConfigSynchronizationService");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.configsynchronizationservice.exclusions", None), "exclusions","ConfigSynchronizationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configsynchronizationservice.enable", None), "enable","ConfigSynchronizationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configsynchronizationservice.synchonserverstartup", None), "synchOnServerStartup","ConfigSynchronizationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configsynchronizationservice.autosynchenabled", None), "autoSynchEnabled","ConfigSynchronizationService");
  if len(atts) != 0:
    print "Modifying ConfigSynchronizationService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConfigSynchronizationService configuration up to date.";

  Property.removeProperties(objid,'properties',"FileTransferService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('ConfigSynchronizationService');
