from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSNAdministeredSubscriber')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSNAdministeredSubscriber");
  exportedObject.put("roleName", "WebSphereWSNAdministeredSubscriber");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnadministeredsubscriber.topic", objid, "topic","WSNAdministeredSubscriber");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnadministeredsubscriber.producerendpoint", objid, "producerEndpoint","WSNAdministeredSubscriber");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnadministeredsubscriber.topicnamespace", objid, "topicNamespace","WSNAdministeredSubscriber");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnadministeredsubscriber.dialect", objid, "dialect","WSNAdministeredSubscriber");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnadministeredsubscriber.uuid", objid, "uuid","WSNAdministeredSubscriber");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnadministeredsubscriber.remotesubscriptiontimeout", objid, "remoteSubscriptionTimeout","WSNAdministeredSubscriber");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"WSNAdministeredSubscriber");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSNAdministeredSubscriber');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSNAdministeredSubscriber')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNAdministeredSubscriber resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "topic", roleProperties.optString("websphere.wsnadministeredsubscriber.topic", None));
  Util.addIfNotNone(properties, "producerEndpoint", roleProperties.optString("websphere.wsnadministeredsubscriber.producerendpoint", None));
  Util.addIfNotNone(properties, "topicNamespace", roleProperties.optString("websphere.wsnadministeredsubscriber.topicnamespace", None));
  Util.addIfNotNone(properties, "dialect", roleProperties.optString("websphere.wsnadministeredsubscriber.dialect", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.wsnadministeredsubscriber.uuid", None));
  Util.addIfNotNone(properties, "remoteSubscriptionTimeout", roleProperties.optString("websphere.wsnadministeredsubscriber.remotesubscriptiontimeout", None));
  print "Creating WSNAdministeredSubscriber with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSNAdministeredSubscriber", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNAdministeredSubscriber');

def update(objid,jsonobject):
  Util.pushPathElement('WSNAdministeredSubscriber')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNAdministeredSubscriber resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnadministeredsubscriber.topic", None), "topic","WSNAdministeredSubscriber");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnadministeredsubscriber.producerendpoint", None), "producerEndpoint","WSNAdministeredSubscriber");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnadministeredsubscriber.topicnamespace", None), "topicNamespace","WSNAdministeredSubscriber");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnadministeredsubscriber.dialect", None), "dialect","WSNAdministeredSubscriber");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnadministeredsubscriber.uuid", None), "uuid","WSNAdministeredSubscriber");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnadministeredsubscriber.remotesubscriptiontimeout", None), "remoteSubscriptionTimeout","WSNAdministeredSubscriber");
  if len(atts) != 0:
    print "Modifying WSNAdministeredSubscriber with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSNAdministeredSubscriber configuration up to date.";

  Property.removeProperties(objid, 'property',"WSNAdministeredSubscriber");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNAdministeredSubscriber');
