from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuthConfigProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthConfigProvider");
  exportedObject.put("roleName", "WebSphereAuthConfigProvider");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authconfigprovider.providerid", objid, "providerID","AuthConfigProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authconfigprovider.classname", objid, "className","AuthConfigProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authconfigprovider.msglayer", objid, "msgLayer","AuthConfigProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authconfigprovider.description", objid, "description","AuthConfigProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AuthConfigProvider");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthConfigProvider');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthConfigProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthConfigProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "providerID", roleProperties.optString("websphere.authconfigprovider.providerid", None));
  Util.addIfNotNone(properties, "className", roleProperties.optString("websphere.authconfigprovider.classname", None));
  Util.addIfNotNone(properties, "msgLayer", roleProperties.optString("websphere.authconfigprovider.msglayer", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.authconfigprovider.description", None));
  print "Creating AuthConfigProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthConfigProvider", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthConfigProvider');


def update(objid,jsonobject):
  Util.pushPathElement('AuthConfigProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthConfigProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authconfigprovider.providerid", None), "providerID","AuthConfigProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authconfigprovider.classname", None), "className","AuthConfigProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authconfigprovider.msglayer", None), "msgLayer","AuthConfigProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authconfigprovider.description", None), "description","AuthConfigProvider");
  if len(atts) != 0:
    print "Modifying AuthConfigProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthConfigProvider configuration up to date.";

  Property.removeProperties(objid, 'properties',"AuthConfigProvider");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthConfigProvider');
