###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ConnectionPool import ConnectionPool
from Property import Property
from MappingModule import MappingModule

__name_att__ = "websphere.mqconnectionfactory.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MQConnectionFactory');

  containmentpath = "%(parentconpath)sMQConnectionFactory:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MQConnectionFactory')

  name = Util.getRequiredAttribute(objid, "name", 'MQConnectionFactory');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMQConnectionFactory");
  exportedObject.put("roleName", "WebSphereMQConnectionFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.wmqserverendpoint", objid, "wmqServerEndpoint","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.secexit", objid, "secExit","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.pubsubcleanupinterval", objid, "pubSubCleanupInterval","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.description", objid, "description","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.providerversion", objid, "providerVersion","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.brokerccsubq", objid, "brokerCCSubQ","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.wildcardformat", objid, "wildcardFormat","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.logmissingtransactioncontext", objid, "logMissingTransactionContext","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sslconfiguration", objid, "sslConfiguration","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.diagnoseconnectionusage", objid, "diagnoseConnectionUsage","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sslpeername", objid, "sslPeerName","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sparsesubscriptions", objid, "sparseSubscriptions","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.ccdturl", objid, "ccdtUrl","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.publishackinterval", objid, "publishAckInterval","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.failifquiesce", objid, "failIfQuiesce","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.rcvexit", objid, "rcvExit","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.proxyhostname", objid, "proxyHostName","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sslcrl", objid, "sslCRL","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.clientid", objid, "clientID","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.brokercontrolqueue", objid, "brokerControlQueue","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.ccsid", objid, "CCSID","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.proxyport", objid, "proxyPort","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.port", objid, "port","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.brokerpubqueue", objid, "brokerPubQueue","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sslresetcount", objid, "sslResetCount","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sendexit", objid, "sendExit","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.wmqservername", objid, "wmqServerName","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.authmechanismpreference", objid, "authMechanismPreference","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.clonesupport", objid, "cloneSupport","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.xaenabled", objid, "XAEnabled","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.authdataalias", objid, "authDataAlias","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.pollinginterval", objid, "pollingInterval","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.rescaninterval", objid, "rescanInterval","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.jndiname", objid, "jndiName","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.directauth", objid, "directAuth","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sendexitinitdata", objid, "sendExitInitData","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.brokerqueuemanager", objid, "brokerQueueManager","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.qmgrtype", objid, "qmgrType","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.queuemanager", objid, "queueManager","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.sslciphersuite", objid, "sslCipherSuite","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.inheritrrscontext", objid, "inheritRRSContext","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.rcvexitinitdata", objid, "rcvExitInitData","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.localaddress", objid, "localAddress","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.name", objid, "name","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.temptopicprefix", objid, "tempTopicPrefix","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.xarecoveryauthalias", objid, "xaRecoveryAuthAlias","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.transporttype", objid, "transportType","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.brokersubqueue", objid, "brokerSubQueue","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.clientreconnectoptions", objid, "clientReconnectOptions","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.ssltype", objid, "sslType","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.compressheaders", objid, "compressHeaders","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.channel", objid, "channel","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.replywithrfh2", objid, "replyWithRFH2","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.connamelist", objid, "connameList","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.maxbatchsize", objid, "maxBatchSize","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.clientreconnecttimeout", objid, "clientReconnectTimeout","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.brokerversion", objid, "brokerVersion","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.useconnectionpooling", objid, "useConnectionPooling","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.pubsubcleanup", objid, "pubSubCleanup","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.tempqueueprefix", objid, "tempQueuePrefix","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.managecachedhandles", objid, "manageCachedHandles","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.tempmodel", objid, "tempModel","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.substore", objid, "substore","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.secexitinitdata", objid, "secExitInitData","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.msgselection", objid, "msgSelection","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.compresspayload", objid, "compressPayload","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.msgretention", objid, "msgRetention","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.wmqserversvrconnchannel", objid, "wmqServerSvrconnChannel","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.providertype", objid, "providerType","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.host", objid, "host","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.statrefreshinterval", objid, "statRefreshInterval","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.category", objid, "category","MQConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqconnectionfactory.multicast", objid, "multicast","MQConnectionFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MQConnectionFactory");

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'MQConnectionFactory');
  if connPool is not None and len(connPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(connPool, currespath, 'ConnectionPool'));

  sessPool = Util.getOptionalAttribute(objid, 'sessionPool', 'MQConnectionFactory');
  if sessPool is not None and len(sessPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(sessPool, currespath, 'SessionPool'));

  mapping = Util.getOptionalAttribute(objid, 'mapping', 'MQConnectionFactory');
  if mapping is not None and len(mapping) > 0:
    returndict = Util.createTypeFolder(respath, "MappingModule", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, MappingModule._export(mapping, currespath, 'MappingModule'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MQConnectionFactory');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MQConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.mqconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqconnectionfactory.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MQConnectionFactory on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MQConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqconnectionfactory.name!");

  properties = [];
  Util.addIfNotNone(properties, "wmqServerEndpoint", roleProperties.optString("websphere.mqconnectionfactory.wmqserverendpoint", None));
  Util.addIfNotNone(properties, "secExit", roleProperties.optString("websphere.mqconnectionfactory.secexit", None));
  Util.addIfNotNone(properties, "pubSubCleanupInterval", roleProperties.optString("websphere.mqconnectionfactory.pubsubcleanupinterval", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.mqconnectionfactory.description", None));
  Util.addIfNotNone(properties, "providerVersion", roleProperties.optString("websphere.mqconnectionfactory.providerversion", None));
  Util.addIfNotNone(properties, "brokerCCSubQ", roleProperties.optString("websphere.mqconnectionfactory.brokerccsubq", None));
  Util.addIfNotNone(properties, "wildcardFormat", roleProperties.optString("websphere.mqconnectionfactory.wildcardformat", None));
  Util.addIfNotNone(properties, "logMissingTransactionContext", roleProperties.optString("websphere.mqconnectionfactory.logmissingtransactioncontext", None));
  Util.addIfNotNone(properties, "sslConfiguration", roleProperties.optString("websphere.mqconnectionfactory.sslconfiguration", None));
  Util.addIfNotNone(properties, "diagnoseConnectionUsage", roleProperties.optString("websphere.mqconnectionfactory.diagnoseconnectionusage", None));
  Util.addIfNotNone(properties, "sslPeerName", roleProperties.optString("websphere.mqconnectionfactory.sslpeername", None));
  Util.addIfNotNone(properties, "sparseSubscriptions", roleProperties.optString("websphere.mqconnectionfactory.sparsesubscriptions", None));
  Util.addIfNotNone(properties, "ccdtUrl", roleProperties.optString("websphere.mqconnectionfactory.ccdturl", None));
  Util.addIfNotNone(properties, "publishAckInterval", roleProperties.optString("websphere.mqconnectionfactory.publishackinterval", None));
  Util.addIfNotNone(properties, "failIfQuiesce", roleProperties.optString("websphere.mqconnectionfactory.failifquiesce", None));
  Util.addIfNotNone(properties, "rcvExit", roleProperties.optString("websphere.mqconnectionfactory.rcvexit", None));
  Util.addIfNotNone(properties, "proxyHostName", roleProperties.optString("websphere.mqconnectionfactory.proxyhostname", None));
  Util.addIfNotNone(properties, "sslCRL", roleProperties.optString("websphere.mqconnectionfactory.sslcrl", None));
  Util.addIfNotNone(properties, "clientID", roleProperties.optString("websphere.mqconnectionfactory.clientid", None));
  Util.addIfNotNone(properties, "brokerControlQueue", roleProperties.optString("websphere.mqconnectionfactory.brokercontrolqueue", None));
  Util.addIfNotNone(properties, "CCSID", roleProperties.optString("websphere.mqconnectionfactory.ccsid", None));
  Util.addIfNotNone(properties, "proxyPort", roleProperties.optString("websphere.mqconnectionfactory.proxyport", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.mqconnectionfactory.port", None));
  Util.addIfNotNone(properties, "brokerPubQueue", roleProperties.optString("websphere.mqconnectionfactory.brokerpubqueue", None));
  Util.addIfNotNone(properties, "sslResetCount", roleProperties.optString("websphere.mqconnectionfactory.sslresetcount", None));
  Util.addIfNotNone(properties, "sendExit", roleProperties.optString("websphere.mqconnectionfactory.sendexit", None));
  Util.addIfNotNone(properties, "wmqServerName", roleProperties.optString("websphere.mqconnectionfactory.wmqservername", None));
  Util.addIfNotNone(properties, "authMechanismPreference", roleProperties.optString("websphere.mqconnectionfactory.authmechanismpreference", None));
  Util.addIfNotNone(properties, "cloneSupport", roleProperties.optString("websphere.mqconnectionfactory.clonesupport", None));
  Util.addIfNotNone(properties, "XAEnabled", roleProperties.optString("websphere.mqconnectionfactory.xaenabled", None));
  Util.addIfNotNone(properties, "authDataAlias", roleProperties.optString("websphere.mqconnectionfactory.authdataalias", None));
  Util.addIfNotNone(properties, "pollingInterval", roleProperties.optString("websphere.mqconnectionfactory.pollinginterval", None));
  Util.addIfNotNone(properties, "rescanInterval", roleProperties.optString("websphere.mqconnectionfactory.rescaninterval", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.mqconnectionfactory.jndiname", None));
  Util.addIfNotNone(properties, "directAuth", roleProperties.optString("websphere.mqconnectionfactory.directauth", None));
  Util.addIfNotNone(properties, "sendExitInitData", roleProperties.optString("websphere.mqconnectionfactory.sendexitinitdata", None));
  Util.addIfNotNone(properties, "brokerQueueManager", roleProperties.optString("websphere.mqconnectionfactory.brokerqueuemanager", None));
  Util.addIfNotNone(properties, "qmgrType", roleProperties.optString("websphere.mqconnectionfactory.qmgrtype", None));
  Util.addIfNotNone(properties, "queueManager", roleProperties.optString("websphere.mqconnectionfactory.queuemanager", None));
  Util.addIfNotNone(properties, "sslCipherSuite", roleProperties.optString("websphere.mqconnectionfactory.sslciphersuite", None));
  Util.addIfNotNone(properties, "inheritRRSContext", roleProperties.optString("websphere.mqconnectionfactory.inheritrrscontext", "false"));
  Util.addIfNotNone(properties, "rcvExitInitData", roleProperties.optString("websphere.mqconnectionfactory.rcvexitinitdata", None));
  Util.addIfNotNone(properties, "localAddress", roleProperties.optString("websphere.mqconnectionfactory.localaddress", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mqconnectionfactory.name", None));
  Util.addIfNotNone(properties, "tempTopicPrefix", roleProperties.optString("websphere.mqconnectionfactory.temptopicprefix", None));
  Util.addIfNotNone(properties, "xaRecoveryAuthAlias", roleProperties.optString("websphere.mqconnectionfactory.xarecoveryauthalias", None));
  Util.addIfNotNone(properties, "transportType", roleProperties.optString("websphere.mqconnectionfactory.transporttype", None));
  Util.addIfNotNone(properties, "brokerSubQueue", roleProperties.optString("websphere.mqconnectionfactory.brokersubqueue", None));
  Util.addIfNotNone(properties, "clientReconnectOptions", roleProperties.optString("websphere.mqconnectionfactory.clientreconnectoptions", "DISABLED"));
  Util.addIfNotNone(properties, "sslType", roleProperties.optString("websphere.mqconnectionfactory.ssltype", None));
  Util.addIfNotNone(properties, "compressHeaders", roleProperties.optString("websphere.mqconnectionfactory.compressheaders", None));
  Util.addIfNotNone(properties, "channel", roleProperties.optString("websphere.mqconnectionfactory.channel", None));
  Util.addIfNotNone(properties, "replyWithRFH2", roleProperties.optString("websphere.mqconnectionfactory.replywithrfh2", None));
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.mqconnectionfactory.connamelist"):
    Util.addIfNotNone(properties, "connameList", roleProperties.optString("websphere.mqconnectionfactory.connamelist", ""));
  Util.addIfNotNone(properties, "maxBatchSize", roleProperties.optString("websphere.mqconnectionfactory.maxbatchsize", None));
  Util.addIfNotNone(properties, "clientReconnectTimeout", roleProperties.optString("websphere.mqconnectionfactory.clientreconnecttimeout", "1800"));
  Util.addIfNotNone(properties, "brokerVersion", roleProperties.optString("websphere.mqconnectionfactory.brokerversion", None));
  Util.addIfNotNone(properties, "useConnectionPooling", roleProperties.optString("websphere.mqconnectionfactory.useconnectionpooling", None));
  Util.addIfNotNone(properties, "pubSubCleanup", roleProperties.optString("websphere.mqconnectionfactory.pubsubcleanup", None));
  Util.addIfNotNone(properties, "tempQueuePrefix", roleProperties.optString("websphere.mqconnectionfactory.tempqueueprefix", None));
  Util.addIfNotNone(properties, "manageCachedHandles", roleProperties.optString("websphere.mqconnectionfactory.managecachedhandles", None));
  Util.addIfNotNone(properties, "tempModel", roleProperties.optString("websphere.mqconnectionfactory.tempmodel", None));
  Util.addIfNotNone(properties, "substore", roleProperties.optString("websphere.mqconnectionfactory.substore", None));
  Util.addIfNotNone(properties, "secExitInitData", roleProperties.optString("websphere.mqconnectionfactory.secexitinitdata", None));
  Util.addIfNotNone(properties, "msgSelection", roleProperties.optString("websphere.mqconnectionfactory.msgselection", None));
  Util.addIfNotNone(properties, "compressPayload", roleProperties.optString("websphere.mqconnectionfactory.compresspayload", None));
  Util.addIfNotNone(properties, "msgRetention", roleProperties.optString("websphere.mqconnectionfactory.msgretention", None));
  Util.addIfNotNone(properties, "wmqServerSvrconnChannel", roleProperties.optString("websphere.mqconnectionfactory.wmqserversvrconnchannel", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.mqconnectionfactory.providertype", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.mqconnectionfactory.host", None));
  Util.addIfNotNone(properties, "statRefreshInterval", roleProperties.optString("websphere.mqconnectionfactory.statrefreshinterval", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.mqconnectionfactory.category", None));
  Util.addIfNotNone(properties, "multicast", roleProperties.optString("websphere.mqconnectionfactory.multicast", None));
  print "Creating MQConnectionFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MQConnectionFactory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereConnectionPool":
        poolname = curjsonobject.getString("name");
        if poolname == "ConnectionPool":
          ConnectionPool.create(objid, curjsonobject, "connectionPool");
        elif poolname == "SessionPool":
          ConnectionPool.create(objid, curjsonobject, "sessionPool");
        else:
          ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQConnectionFactory');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MQConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqconnectionfactory.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.wmqserverendpoint", None), "wmqServerEndpoint","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.secexit", None), "secExit","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.pubsubcleanupinterval", None), "pubSubCleanupInterval","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.description", None), "description","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.providerversion", None), "providerVersion","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.brokerccsubq", None), "brokerCCSubQ","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.wildcardformat", None), "wildcardFormat","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.logmissingtransactioncontext", None), "logMissingTransactionContext","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sslconfiguration", None), "sslConfiguration","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.diagnoseconnectionusage", None), "diagnoseConnectionUsage","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sslpeername", None), "sslPeerName","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sparsesubscriptions", None), "sparseSubscriptions","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.ccdturl", None), "ccdtUrl","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.publishackinterval", None), "publishAckInterval","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.failifquiesce", None), "failIfQuiesce","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.rcvexit", None), "rcvExit","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.proxyhostname", None), "proxyHostName","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sslcrl", None), "sslCRL","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.clientid", None), "clientID","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.brokercontrolqueue", None), "brokerControlQueue","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.ccsid", None), "CCSID","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.proxyport", None), "proxyPort","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.port", None), "port","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.brokerpubqueue", None), "brokerPubQueue","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sslresetcount", None), "sslResetCount","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sendexit", None), "sendExit","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.wmqservername", None), "wmqServerName","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.authmechanismpreference", None), "authMechanismPreference","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.clonesupport", None), "cloneSupport","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.xaenabled", None), "XAEnabled","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.authdataalias", None), "authDataAlias","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.pollinginterval", None), "pollingInterval","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.rescaninterval", None), "rescanInterval","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.jndiname", None), "jndiName","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.directauth", None), "directAuth","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sendexitinitdata", None), "sendExitInitData","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.brokerqueuemanager", None), "brokerQueueManager","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.qmgrtype", None), "qmgrType","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.queuemanager", None), "queueManager","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.sslciphersuite", None), "sslCipherSuite","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.inheritrrscontext", "false"), "inheritRRSContext","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.rcvexitinitdata", None), "rcvExitInitData","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.localaddress", None), "localAddress","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.name", None), "name","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.temptopicprefix", None), "tempTopicPrefix","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.xarecoveryauthalias", None), "xaRecoveryAuthAlias","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.transporttype", None), "transportType","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.brokersubqueue", None), "brokerSubQueue","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.clientreconnectoptions", "DISABLED"), "clientReconnectOptions","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.ssltype", None), "sslType","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.compressheaders", None), "compressHeaders","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.channel", None), "channel","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.replywithrfh2", None), "replyWithRFH2","MQConnectionFactory");
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.mqconnectionfactory.connamelist"):
    Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.connamelist", ""), "connameList","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.maxbatchsize", None), "maxBatchSize","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.clientreconnecttimeout", "1800"), "clientReconnectTimeout","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.brokerversion", None), "brokerVersion","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.useconnectionpooling", None), "useConnectionPooling","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.pubsubcleanup", None), "pubSubCleanup","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.tempqueueprefix", None), "tempQueuePrefix","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.managecachedhandles", None), "manageCachedHandles","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.tempmodel", None), "tempModel","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.substore", None), "substore","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.secexitinitdata", None), "secExitInitData","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.msgselection", None), "msgSelection","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.compresspayload", None), "compressPayload","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.msgretention", None), "msgRetention","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.wmqserversvrconnchannel", None), "wmqServerSvrconnChannel","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.providertype", None), "providerType","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.host", None), "host","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.statrefreshinterval", None), "statRefreshInterval","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.category", None), "category","MQConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqconnectionfactory.multicast", None), "multicast","MQConnectionFactory");
  if len(atts) != 0:
    print "Modifying MQConnectionFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MQConnectionFactory configuration up to date.";

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'MQConnectionFactory');
  if connPool is not None and len(connPool) > 0:
    Util.remove(connPool);

  mapping = Util.getOptionalAttribute(objid, 'mapping', 'MQConnectionFactory');
  if mapping is not None and len(mapping) > 0:
    Util.remove(mapping);

  sessPool = Util.getOptionalAttribute(objid, 'sessionPool', 'MQConnectionFactory');
  if sessPool is not None and len(sessPool) > 0:
    Util.remove(sessPool);

  Property.removeProperties(objid, 'properties',"MQConnectionFactory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereConnectionPool":
        poolname = curjsonobject.getString("name");
        if poolname == "ConnectionPool":
          ConnectionPool.create(objid, curjsonobject, "connectionPool");
        elif poolname == "SessionPool":
          ConnectionPool.create(objid, curjsonobject, "sessionPool");
        else:
          ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQConnectionFactory');
