from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from RoutingPolicy import RoutingPolicy
from CustomAdvisorPolicy import CustomAdvisorPolicy
from CustomErrorPagePolicy import CustomErrorPagePolicy
from LocalErrorPagePolicy import LocalErrorPagePolicy
from PluginConfigPolicy import PluginConfigPolicy
from RewritingPolicy import RewritingPolicy
from StaticCachePolicy import StaticCachePolicy
from StaticFileServingPolicy import StaticFileServingPolicy
from WorkloadManagementPolicy import WorkloadManagementPolicy
from URIGroup import URIGroup
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProxySettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProxySettings");
  exportedObject.put("roleName", "WebSphereProxySettings");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enablelogging", objid, "enableLogging","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.connectionpoolenable", objid, "connectionPoolEnable","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.maxrequestbodybufferchunksize", objid, "maxRequestBodyBufferChunkSize","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.localaccesslog", objid, "localAccessLog","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enabledynamiccache", objid, "enableDynamicCache","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enablecustomerrorpagepolicy", objid, "enableCustomErrorPagePolicy","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.sslcacheenable", objid, "sslCacheEnable","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.outboundsslalias", objid, "outboundSSLAlias","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.outboundrequesttimeout", objid, "outboundRequestTimeout","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.maximumlogsize", objid, "maximumLogSize","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enablecaching", objid, "enableCaching","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enablestaticrouting", objid, "enableStaticRouting","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.proxyaccesslog", objid, "proxyAccessLog","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.cacheaccesslog", objid, "cacheAccessLog","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.excludeurigroup", objid, "excludeURIGroup","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.staticroutingfiledirectory", objid, "staticRoutingFileDirectory","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enableesi", objid, "enableESI","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.outboundrequestwritetimeout", objid, "outboundRequestWriteTimeout","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.memorycacheentrysizeinmb", objid, "memoryCacheEntrySizeInMB","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.cacheinstancename", objid, "cacheInstanceName","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enablewebservicessupport", objid, "enableWebServicesSupport","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.maxconnectionsperserver", objid, "maxConnectionsPerServer","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.serverheader", objid, "serverHeader","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.cacheupdateuri", objid, "cacheUpdateUri","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.maxresponsebodybufferchunksize", objid, "maxResponseBodyBufferChunkSize","ProxySettings");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.proxysettings.methodsdisable", objid, "methodsDisable","ProxySettings");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.proxysettings.trustedintermediaryaddresses", objid, "trustedIntermediaryAddresses","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.outboundconnecttimeout", objid, "outboundConnectTimeout","ProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxysettings.enableaggressivecaching", objid, "enableAggressiveCaching","ProxySettings");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ProxySettings");

  routingPolicy = Util.getOptionalAttribute(objid, 'routingPolicy',"ProxySettings");
  if routingPolicy is not None and len(routingPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "RoutingPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, RoutingPolicy._export(routingPolicy, currespath, "Routing Policy"));

  customAdvisorPolicy = Util.getOptionalAttribute(objid, 'customAdvisorPolicy',"ProxySettings");
  if customAdvisorPolicy is not None and len(customAdvisorPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "CustomAdvisorPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, CustomAdvisorPolicy._export(customAdvisorPolicy, currespath, "Custom Advisor Policy"));

  customErrorPagePolicy = Util.getOptionalAttribute(objid, 'errorPagePolicy',"ProxySettings");
  if customErrorPagePolicy is not None and len(customErrorPagePolicy) > 0:
    returndict = Util.createTypeFolder(respath, "CustomErrorPagePolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, CustomErrorPagePolicy._export(customErrorPagePolicy, currespath, "Custom Error Page Policy"));

  localErrorPagePolicy = Util.getOptionalAttribute(objid, 'localErrorPagePolicy',"ProxySettings");
  if localErrorPagePolicy is not None and len(localErrorPagePolicy) > 0:
    returndict = Util.createTypeFolder(respath, "LocalErrorPagePolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, LocalErrorPagePolicy._export(localErrorPagePolicy, currespath, "Local Error Page Policy"));

  pluginConfigPolicy = Util.getOptionalAttribute(objid, 'pluginConfigPolicy',"ProxySettings");
  if pluginConfigPolicy is not None and len(pluginConfigPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "PluginConfigPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, PluginConfigPolicy._export(pluginConfigPolicy, currespath, "Plugin Config Policy"));

  rewritingPolicy = Util.getOptionalAttribute(objid, 'rewritingPolicy',"ProxySettings");
  if rewritingPolicy is not None and len(rewritingPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "RewritingPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, RewritingPolicy._export(rewritingPolicy, currespath, "Rewriting Policy"));

  staticCachePolicy = Util.getOptionalAttribute(objid, 'staticCachePolicy',"ProxySettings");
  if staticCachePolicy is not None and len(staticCachePolicy) > 0:
    returndict = Util.createTypeFolder(respath, "StaticCachePolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StaticCachePolicy._export(staticCachePolicy, currespath, "Static Cache Policy"));

  staticFileServingPolicy = Util.getOptionalAttribute(objid, 'staticFileServingPolicy',"ProxySettings");
  if staticFileServingPolicy is not None and len(staticFileServingPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "StaticFileServingPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StaticFileServingPolicy._export(staticFileServingPolicy, currespath, "Static File Serving Policy"));

  workloadManagementPolicy = Util.getOptionalAttribute(objid, 'workloadManagementPolicy',"ProxySettings");
  if workloadManagementPolicy is not None and len(workloadManagementPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "WorkloadManagementPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, WorkloadManagementPolicy._export(workloadManagementPolicy, currespath, "Workload Management Policy"));

  i = 0;
  uriGroups = Util.parseConfigIdListAttribute(objid, 'uriGroups',"ProxySettings");
  for uriGroup in uriGroups:
    if len(uriGroup) > 0:
      returndict = Util.createTypeFolder(respath, "URIGroup", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, URIGroup._export(uriGroup, currespath, "URI Group%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProxySettings');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProxySettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxySettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableLogging", roleProperties.optString("websphere.proxysettings.enablelogging", None));
  Util.addIfNotNone(properties, "connectionPoolEnable", roleProperties.optString("websphere.proxysettings.connectionpoolenable", None));
  Util.addIfNotNone(properties, "maxRequestBodyBufferChunkSize", roleProperties.optString("websphere.proxysettings.maxrequestbodybufferchunksize", None));
  Util.addIfNotNone(properties, "localAccessLog", roleProperties.optString("websphere.proxysettings.localaccesslog", None));
  Util.addIfNotNone(properties, "enableDynamicCache", roleProperties.optString("websphere.proxysettings.enabledynamiccache", None));
  Util.addIfNotNone(properties, "enableCustomErrorPagePolicy", roleProperties.optString("websphere.proxysettings.enablecustomerrorpagepolicy", None));
  Util.addIfNotNone(properties, "sslCacheEnable", roleProperties.optString("websphere.proxysettings.sslcacheenable", None));
  Util.addIfNotNone(properties, "outboundSSLAlias", roleProperties.optString("websphere.proxysettings.outboundsslalias", None));
  Util.addIfNotNone(properties, "outboundRequestTimeout", roleProperties.optString("websphere.proxysettings.outboundrequesttimeout", None));
  Util.addIfNotNone(properties, "maximumLogSize", roleProperties.optString("websphere.proxysettings.maximumlogsize", None));
  Util.addIfNotNone(properties, "enableCaching", roleProperties.optString("websphere.proxysettings.enablecaching", None));
  Util.addIfNotNone(properties, "enableStaticRouting", roleProperties.optString("websphere.proxysettings.enablestaticrouting", None));
  Util.addIfNotNone(properties, "proxyAccessLog", roleProperties.optString("websphere.proxysettings.proxyaccesslog", None));
  Util.addIfNotNone(properties, "cacheAccessLog", roleProperties.optString("websphere.proxysettings.cacheaccesslog", None));
  Util.addIfNotNone(properties, "excludeURIGroup", roleProperties.optString("websphere.proxysettings.excludeurigroup", None));
  Util.addIfNotNone(properties, "staticRoutingFileDirectory", roleProperties.optString("websphere.proxysettings.staticroutingfiledirectory", None));
  Util.addIfNotNone(properties, "enableESI", roleProperties.optString("websphere.proxysettings.enableesi", None));
  Util.addIfNotNone(properties, "outboundRequestWriteTimeout", roleProperties.optString("websphere.proxysettings.outboundrequestwritetimeout", None));
  Util.addIfNotNone(properties, "memoryCacheEntrySizeInMB", roleProperties.optString("websphere.proxysettings.memorycacheentrysizeinmb", None));
  Util.addIfNotNone(properties, "cacheInstanceName", roleProperties.optString("websphere.proxysettings.cacheinstancename", None));
  Util.addIfNotNone(properties, "enableWebServicesSupport", roleProperties.optString("websphere.proxysettings.enablewebservicessupport", None));
  Util.addIfNotNone(properties, "maxConnectionsPerServer", roleProperties.optString("websphere.proxysettings.maxconnectionsperserver", None));
  Util.addIfNotNone(properties, "serverHeader", roleProperties.optString("websphere.proxysettings.serverheader", None));
  Util.addIfNotNone(properties, "cacheUpdateUri", roleProperties.optString("websphere.proxysettings.cacheupdateuri", None));
  Util.addIfNotNone(properties, "maxResponseBodyBufferChunkSize", roleProperties.optString("websphere.proxysettings.maxresponsebodybufferchunksize", None));
  Util.addPathProperty(properties, "methodsDisable", roleProperties.optString("websphere.proxysettings.methodsdisable", None));
  Util.addPathProperty(properties, "trustedIntermediaryAddresses", roleProperties.optString("websphere.proxysettings.trustedintermediaryaddresses", None));
  Util.addIfNotNone(properties, "outboundConnectTimeout", roleProperties.optString("websphere.proxysettings.outboundconnecttimeout", None));
  Util.addIfNotNone(properties, "enableAggressiveCaching", roleProperties.optString("websphere.proxysettings.enableaggressivecaching", None));
  print "Creating ProxySettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProxySettings", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereRoutingPolicy":
        RoutingPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereCustomAdvisorPolicy":
        CustomAdvisorPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereCustomErrorPagePolicy":
        CustomErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereLocalErrorPagePolicy":
        LocalErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSpherePluginConfigPolicy":
        PluginConfigPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereRewritingPolicy":
        RewritingPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereStaticCachePolicy":
        StaticCachePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereStaticFileServingPolicy":
        StaticFileServingPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereWorkloadManagementPolicy":
        WorkloadManagementPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereURIGroup":
        URIGroup.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxySettings');

def update(objid,jsonobject):
  Util.pushPathElement('ProxySettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxySettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enablelogging", None), "enableLogging","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.connectionpoolenable", None), "connectionPoolEnable","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.maxrequestbodybufferchunksize", None), "maxRequestBodyBufferChunkSize","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.localaccesslog", None), "localAccessLog","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enabledynamiccache", None), "enableDynamicCache","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enablecustomerrorpagepolicy", None), "enableCustomErrorPagePolicy","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.sslcacheenable", None), "sslCacheEnable","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.outboundsslalias", None), "outboundSSLAlias","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.outboundrequesttimeout", None), "outboundRequestTimeout","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.maximumlogsize", None), "maximumLogSize","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enablecaching", None), "enableCaching","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enablestaticrouting", None), "enableStaticRouting","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.proxyaccesslog", None), "proxyAccessLog","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.cacheaccesslog", None), "cacheAccessLog","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.excludeurigroup", None), "excludeURIGroup","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.staticroutingfiledirectory", None), "staticRoutingFileDirectory","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enableesi", None), "enableESI","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.outboundrequestwritetimeout", None), "outboundRequestWriteTimeout","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.memorycacheentrysizeinmb", None), "memoryCacheEntrySizeInMB","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.cacheinstancename", None), "cacheInstanceName","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enablewebservicessupport", None), "enableWebServicesSupport","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.maxconnectionsperserver", None), "maxConnectionsPerServer","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.serverheader", None), "serverHeader","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.cacheupdateuri", None), "cacheUpdateUri","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.maxresponsebodybufferchunksize", None), "maxResponseBodyBufferChunkSize","ProxySettings");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.methodsdisable", None), "methodsDisable","ProxySettings");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.trustedintermediaryaddresses", None), "trustedIntermediaryAddresses","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.outboundconnecttimeout", None), "outboundConnectTimeout","ProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxysettings.enableaggressivecaching", None), "enableAggressiveCaching","ProxySettings");
  if len(atts) != 0:
    print "Modifying ProxySettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProxySettings configuration up to date.";

  routingPolicy = Util.getOptionalAttribute(objid, 'routingPolicy',"ProxySettings");
  if routingPolicy is not None and len(routingPolicy) > 0:
    Util.remove(routingPolicy);

  customAdvisorPolicy = Util.getOptionalAttribute(objid, 'customAdvisorPolicy',"ProxySettings");
  if customAdvisorPolicy is not None and len(customAdvisorPolicy) > 0:
    Util.remove(customAdvisorPolicy);

  customErrorPagePolicy = Util.getOptionalAttribute(objid, 'errorPagePolicy',"ProxySettings");
  if customErrorPagePolicy is not None and len(customErrorPagePolicy) > 0:
    Util.remove(customErrorPagePolicy);

  localErrorPagePolicy = Util.getOptionalAttribute(objid, 'localErrorPagePolicy',"ProxySettings");
  if localErrorPagePolicy is not None and len(localErrorPagePolicy) > 0:
    Util.remove(localErrorPagePolicy);

  pluginConfigPolicy = Util.getOptionalAttribute(objid, 'pluginConfigPolicy',"ProxySettings");
  if pluginConfigPolicy is not None and len(pluginConfigPolicy) > 0:
    Util.remove(pluginConfigPolicy);

  rewritingPolicy = Util.getOptionalAttribute(objid, 'rewritingPolicy',"ProxySettings");
  if rewritingPolicy is not None and len(rewritingPolicy) > 0:
    Util.remove(rewritingPolicy);

  staticCachePolicy = Util.getOptionalAttribute(objid, 'staticCachePolicy',"ProxySettings");
  if staticCachePolicy is not None and len(staticCachePolicy) > 0:
    Util.remove(staticCachePolicy);

  staticFileServingPolicy = Util.getOptionalAttribute(objid, 'staticFileServingPolicy',"ProxySettings");
  if staticFileServingPolicy is not None and len(staticFileServingPolicy) > 0:
    Util.remove(staticFileServingPolicy);

  workloadManagementPolicy = Util.getOptionalAttribute(objid, 'workloadManagementPolicy',"ProxySettings");
  if workloadManagementPolicy is not None and len(workloadManagementPolicy) > 0:
    Util.remove(workloadManagementPolicy);

  uriGroups = Util.parseConfigIdListAttribute(objid, 'uriGroups', "ProxySettings");
  for uriGroup in uriGroups:
    if len(uriGroup) > 0:
      Util.remove(uriGroup);

  Property.removeProperties(objid, 'properties',"ProxySettings");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereRoutingPolicy":
        RoutingPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereCustomAdvisorPolicy":
        CustomAdvisorPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereCustomErrorPagePolicy":
        CustomErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereLocalErrorPagePolicy":
        LocalErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSpherePluginConfigPolicy":
        PluginConfigPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereRewritingPolicy":
        RewritingPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereStaticCachePolicy":
        StaticCachePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereStaticFileServingPolicy":
        StaticFileServingPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereWorkloadManagementPolicy":
        WorkloadManagementPolicy.create(objid, curjsonobject);
      elif currole == "WebSphereURIGroup":
        URIGroup.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxySettings');

def getProxySettings(objid):
  proxySettings = Util.getAssociatedObjects(objid, "ProxySettings");
  if proxySettings is not None and len(proxySettings) > 0:
    return proxySettings[0];
  return None;
