from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "ConnectionTest";

  containmentpath = "%(parentconpath)sConnectionTest:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConnectionTest')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConnectionTest");
  exportedObject.put("roleName", "WebSphereConnectionTest");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiontest.pretestconnection", objid, "preTestConnection","ConnectionTest");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiontest.retrylimit", objid, "retryLimit","ConnectionTest");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiontest.retryinterval", objid, "retryInterval","ConnectionTest");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConnectionTest');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionTest resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ConnectionTest on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('ConnectionTest')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionTest resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "preTestConnection", roleProperties.optString("websphere.connectiontest.pretestconnection", None));
  Util.addIfNotNone(properties, "retryLimit", roleProperties.optString("websphere.connectiontest.retrylimit", None));
  Util.addIfNotNone(properties, "retryInterval", roleProperties.optString("websphere.connectiontest.retryinterval", None));
  print "Creating ConnectionTest with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ConnectionTest", parentid, properties);
  Util.popPathElement('ConnectionTest');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ConnectionTest')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionTest resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiontest.pretestconnection", None), "preTestConnection","ConnectionTest");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiontest.retrylimit", None), "retryLimit","ConnectionTest");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiontest.retryinterval", None), "retryInterval","ConnectionTest");
  if len(atts) != 0:
    print "Modifying ConnectionTest with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConnectionTest configuration up to date.";

  Util.popPathElement('ConnectionTest');
