from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExtensionMBean')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExtensionMBean");
  exportedObject.put("roleName", "WebSphereExtensionMBean");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extensionmbean.type", objid, "type","ExtensionMBean");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extensionmbean.descriptoruri", objid, "descriptorURI","ExtensionMBean");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExtensionMBean');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ExtensionMBean')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtensionMBean resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.extensionmbean.type", None));
  Util.addIfNotNone(properties, "descriptorURI", roleProperties.optString("websphere.extensionmbean.descriptoruri", None));
  print "Creating ExtensionMBean with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExtensionMBean", parentid, properties);
  Util.popPathElement('ExtensionMBean');

def update(objid,jsonobject):
  Util.pushPathElement('ExtensionMBean')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtensionMBean resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extensionmbean.type", None), "type","ExtensionMBean");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extensionmbean.descriptoruri", None), "descriptorURI","ExtensionMBean");
  if len(atts) != 0:
    print "Modifying ExtensionMBean with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExtensionMBean configuration up to date.";

  Util.popPathElement('ExtensionMBean');
