from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GridWorkGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGridWorkGoal");
  exportedObject.put("roleName", "WebSphereGridWorkGoal");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GridWorkGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GridWorkGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridWorkGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating GridWorkGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GridWorkGoal", parentid, properties);
  Util.popPathElement('GridWorkGoal');

def update(objid,jsonobject):
  Util.pushPathElement('GridWorkGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridWorkGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying GridWorkGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GridWorkGoal configuration up to date.";

  Util.popPathElement('GridWorkGoal');
