###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ConnectionPool import ConnectionPool
from Property import Property
from MappingModule import MappingModule

__name_att__ = "websphere.mqtopicconnectionfactory.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MQTopicConnectionFactory');

  containmentpath = "%(parentconpath)sMQTopicConnectionFactory:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MQTopicConnectionFactory')

  name = Util.getRequiredAttribute(objid, "name", 'MQTopicConnectionFactory');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMQTopicConnectionFactory");
  exportedObject.put("roleName", "WebSphereMQTopicConnectionFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.wmqserverendpoint", objid, "wmqServerEndpoint","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.secexit", objid, "secExit","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.pubsubcleanupinterval", objid, "pubSubCleanupInterval","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.description", objid, "description","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.providerversion", objid, "providerVersion","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.brokerccsubq", objid, "brokerCCSubQ","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.wildcardformat", objid, "wildcardFormat","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.logmissingtransactioncontext", objid, "logMissingTransactionContext","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sslconfiguration", objid, "sslConfiguration","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.diagnoseconnectionusage", objid, "diagnoseConnectionUsage","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sslpeername", objid, "sslPeerName","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sparsesubscriptions", objid, "sparseSubscriptions","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.ccdturl", objid, "ccdtUrl","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.publishackinterval", objid, "publishAckInterval","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.failifquiesce", objid, "failIfQuiesce","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.rcvexit", objid, "rcvExit","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.proxyhostname", objid, "proxyHostName","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sslcrl", objid, "sslCRL","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.clientid", objid, "clientID","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.brokercontrolqueue", objid, "brokerControlQueue","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.ccsid", objid, "CCSID","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.proxyport", objid, "proxyPort","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.port", objid, "port","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.brokerpubqueue", objid, "brokerPubQueue","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sslresetcount", objid, "sslResetCount","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sendexit", objid, "sendExit","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.wmqservername", objid, "wmqServerName","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.authmechanismpreference", objid, "authMechanismPreference","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.clonesupport", objid, "cloneSupport","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.xaenabled", objid, "XAEnabled","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.authdataalias", objid, "authDataAlias","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.pollinginterval", objid, "pollingInterval","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.rescaninterval", objid, "rescanInterval","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.jndiname", objid, "jndiName","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.directauth", objid, "directAuth","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sendexitinitdata", objid, "sendExitInitData","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.brokerqueuemanager", objid, "brokerQueueManager","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.qmgrtype", objid, "qmgrType","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.queuemanager", objid, "queueManager","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.sslciphersuite", objid, "sslCipherSuite","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.inheritrrscontext", objid, "inheritRRSContext","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.rcvexitinitdata", objid, "rcvExitInitData","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.localaddress", objid, "localAddress","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.name", objid, "name","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.temptopicprefix", objid, "tempTopicPrefix","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.xarecoveryauthalias", objid, "xaRecoveryAuthAlias","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.transporttype", objid, "transportType","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.brokersubqueue", objid, "brokerSubQueue","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.clientreconnectoptions", objid, "clientReconnectOptions","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.ssltype", objid, "sslType","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.compressheaders", objid, "compressHeaders","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.channel", objid, "channel","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.connamelist", objid, "connameList","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.maxbatchsize", objid, "maxBatchSize","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.clientreconnecttimeout", objid, "clientReconnectTimeout","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.brokerversion", objid, "brokerVersion","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.useconnectionpooling", objid, "useConnectionPooling","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.pubsubcleanup", objid, "pubSubCleanup","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.managecachedhandles", objid, "manageCachedHandles","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.tempmodel", objid, "tempModel","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.substore", objid, "substore","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.secexitinitdata", objid, "secExitInitData","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.msgselection", objid, "msgSelection","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.compresspayload", objid, "compressPayload","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.wmqserversvrconnchannel", objid, "wmqServerSvrconnChannel","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.providertype", objid, "providerType","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.host", objid, "host","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.statrefreshinterval", objid, "statRefreshInterval","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.category", objid, "category","MQTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopicconnectionfactory.multicast", objid, "multicast","MQTopicConnectionFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MQTopicConnectionFactory");

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'MQTopicConnectionFactory');
  if connPool is not None and len(connPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(connPool, currespath, 'ConnectionPool'));

  sessPool = Util.getOptionalAttribute(objid, 'sessionPool', 'MQTopicConnectionFactory');
  if sessPool is not None and len(sessPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(sessPool, currespath, 'SessionPool'));

  mapping = Util.getOptionalAttribute(objid, 'mapping', 'MQTopicConnectionFactory');
  if mapping is not None and len(mapping) > 0:
    returndict = Util.createTypeFolder(respath, "MappingModule", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, MappingModule._export(mapping, currespath, 'MappingModule'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MQTopicConnectionFactory');
  return result;


def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MQTopicConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.mqtopicconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqtopicconnectionfactory.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MQTopicConnectionFactory on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MQTopicConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQTopicConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqtopicconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqtopicconnectionfactory.name!");

  properties = [];
  Util.addIfNotNone(properties, "wmqServerEndpoint", roleProperties.optString("websphere.mqtopicconnectionfactory.wmqserverendpoint", None));
  Util.addIfNotNone(properties, "secExit", roleProperties.optString("websphere.mqtopicconnectionfactory.secexit", None));
  Util.addIfNotNone(properties, "pubSubCleanupInterval", roleProperties.optString("websphere.mqtopicconnectionfactory.pubsubcleanupinterval", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.mqtopicconnectionfactory.description", None));
  Util.addIfNotNone(properties, "providerVersion", roleProperties.optString("websphere.mqtopicconnectionfactory.providerversion", None));
  Util.addIfNotNone(properties, "brokerCCSubQ", roleProperties.optString("websphere.mqtopicconnectionfactory.brokerccsubq", None));
  Util.addIfNotNone(properties, "wildcardFormat", roleProperties.optString("websphere.mqtopicconnectionfactory.wildcardformat", None));
  Util.addIfNotNone(properties, "logMissingTransactionContext", roleProperties.optString("websphere.mqtopicconnectionfactory.logmissingtransactioncontext", None));
  Util.addIfNotNone(properties, "sslConfiguration", roleProperties.optString("websphere.mqtopicconnectionfactory.sslconfiguration", None));
  Util.addIfNotNone(properties, "diagnoseConnectionUsage", roleProperties.optString("websphere.mqtopicconnectionfactory.diagnoseconnectionusage", None));
  Util.addIfNotNone(properties, "sslPeerName", roleProperties.optString("websphere.mqtopicconnectionfactory.sslpeername", None));
  Util.addIfNotNone(properties, "sparseSubscriptions", roleProperties.optString("websphere.mqtopicconnectionfactory.sparsesubscriptions", None));
  Util.addIfNotNone(properties, "ccdtUrl", roleProperties.optString("websphere.mqtopicconnectionfactory.ccdturl", None));
  Util.addIfNotNone(properties, "publishAckInterval", roleProperties.optString("websphere.mqtopicconnectionfactory.publishackinterval", None));
  Util.addIfNotNone(properties, "failIfQuiesce", roleProperties.optString("websphere.mqtopicconnectionfactory.failifquiesce", None));
  Util.addIfNotNone(properties, "rcvExit", roleProperties.optString("websphere.mqtopicconnectionfactory.rcvexit", None));
  Util.addIfNotNone(properties, "proxyHostName", roleProperties.optString("websphere.mqtopicconnectionfactory.proxyhostname", None));
  Util.addIfNotNone(properties, "sslCRL", roleProperties.optString("websphere.mqtopicconnectionfactory.sslcrl", None));
  Util.addIfNotNone(properties, "clientID", roleProperties.optString("websphere.mqtopicconnectionfactory.clientid", None));
  Util.addIfNotNone(properties, "brokerControlQueue", roleProperties.optString("websphere.mqtopicconnectionfactory.brokercontrolqueue", None));
  Util.addIfNotNone(properties, "CCSID", roleProperties.optString("websphere.mqtopicconnectionfactory.ccsid", None));
  Util.addIfNotNone(properties, "proxyPort", roleProperties.optString("websphere.mqtopicconnectionfactory.proxyport", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.mqtopicconnectionfactory.port", None));
  Util.addIfNotNone(properties, "brokerPubQueue", roleProperties.optString("websphere.mqtopicconnectionfactory.brokerpubqueue", None));
  Util.addIfNotNone(properties, "sslResetCount", roleProperties.optString("websphere.mqtopicconnectionfactory.sslresetcount", None));
  Util.addIfNotNone(properties, "sendExit", roleProperties.optString("websphere.mqtopicconnectionfactory.sendexit", None));
  Util.addIfNotNone(properties, "wmqServerName", roleProperties.optString("websphere.mqtopicconnectionfactory.wmqservername", None));
  Util.addIfNotNone(properties, "authMechanismPreference", roleProperties.optString("websphere.mqtopicconnectionfactory.authmechanismpreference", None));
  Util.addIfNotNone(properties, "cloneSupport", roleProperties.optString("websphere.mqtopicconnectionfactory.clonesupport", None));
  Util.addIfNotNone(properties, "XAEnabled", roleProperties.optString("websphere.mqtopicconnectionfactory.xaenabled", None));
  Util.addIfNotNone(properties, "authDataAlias", roleProperties.optString("websphere.mqtopicconnectionfactory.authdataalias", None));
  Util.addIfNotNone(properties, "pollingInterval", roleProperties.optString("websphere.mqtopicconnectionfactory.pollinginterval", None));
  Util.addIfNotNone(properties, "rescanInterval", roleProperties.optString("websphere.mqtopicconnectionfactory.rescaninterval", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.mqtopicconnectionfactory.jndiname", None));
  Util.addIfNotNone(properties, "directAuth", roleProperties.optString("websphere.mqtopicconnectionfactory.directauth", None));
  Util.addIfNotNone(properties, "sendExitInitData", roleProperties.optString("websphere.mqtopicconnectionfactory.sendexitinitdata", None));
  Util.addIfNotNone(properties, "brokerQueueManager", roleProperties.optString("websphere.mqtopicconnectionfactory.brokerqueuemanager", None));
  Util.addIfNotNone(properties, "qmgrType", roleProperties.optString("websphere.mqtopicconnectionfactory.qmgrtype", None));
  Util.addIfNotNone(properties, "queueManager", roleProperties.optString("websphere.mqtopicconnectionfactory.queuemanager", None));
  Util.addIfNotNone(properties, "sslCipherSuite", roleProperties.optString("websphere.mqtopicconnectionfactory.sslciphersuite", None));
  Util.addIfNotNone(properties, "inheritRRSContext", roleProperties.optString("websphere.mqtopicconnectionfactory.inheritrrscontext", "false"));
  Util.addIfNotNone(properties, "rcvExitInitData", roleProperties.optString("websphere.mqtopicconnectionfactory.rcvexitinitdata", None));
  Util.addIfNotNone(properties, "localAddress", roleProperties.optString("websphere.mqtopicconnectionfactory.localaddress", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mqtopicconnectionfactory.name", None));
  Util.addIfNotNone(properties, "tempTopicPrefix", roleProperties.optString("websphere.mqtopicconnectionfactory.temptopicprefix", None));
  Util.addIfNotNone(properties, "xaRecoveryAuthAlias", roleProperties.optString("websphere.mqtopicconnectionfactory.xarecoveryauthalias", None));
  Util.addIfNotNone(properties, "transportType", roleProperties.optString("websphere.mqtopicconnectionfactory.transporttype", None));
  Util.addIfNotNone(properties, "brokerSubQueue", roleProperties.optString("websphere.mqtopicconnectionfactory.brokersubqueue", None));
  Util.addIfNotNone(properties, "clientReconnectOptions", roleProperties.optString("websphere.mqtopicconnectionfactory.clientreconnectoptions", "DISABLED"));
  Util.addIfNotNone(properties, "sslType", roleProperties.optString("websphere.mqtopicconnectionfactory.ssltype", None));
  Util.addIfNotNone(properties, "compressHeaders", roleProperties.optString("websphere.mqtopicconnectionfactory.compressheaders", None));
  Util.addIfNotNone(properties, "channel", roleProperties.optString("websphere.mqtopicconnectionfactory.channel", None));
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.mqtopicconnectionfactory.connamelist"):
    Util.addIfNotNone(properties, "connameList", roleProperties.optString("websphere.mqtopicconnectionfactory.connamelist", ""));
  Util.addIfNotNone(properties, "maxBatchSize", roleProperties.optString("websphere.mqtopicconnectionfactory.maxbatchsize", None));
  Util.addIfNotNone(properties, "clientReconnectTimeout", roleProperties.optString("websphere.mqtopicconnectionfactory.clientreconnecttimeout", "1800"));
  Util.addIfNotNone(properties, "brokerVersion", roleProperties.optString("websphere.mqtopicconnectionfactory.brokerversion", None));
  Util.addIfNotNone(properties, "useConnectionPooling", roleProperties.optString("websphere.mqtopicconnectionfactory.useconnectionpooling", None));
  Util.addIfNotNone(properties, "pubSubCleanup", roleProperties.optString("websphere.mqtopicconnectionfactory.pubsubcleanup", None));
  Util.addIfNotNone(properties, "manageCachedHandles", roleProperties.optString("websphere.mqtopicconnectionfactory.managecachedhandles", None));
  Util.addIfNotNone(properties, "tempModel", roleProperties.optString("websphere.mqtopicconnectionfactory.tempmodel", None));
  Util.addIfNotNone(properties, "substore", roleProperties.optString("websphere.mqtopicconnectionfactory.substore", None));
  Util.addIfNotNone(properties, "secExitInitData", roleProperties.optString("websphere.mqtopicconnectionfactory.secexitinitdata", None));
  Util.addIfNotNone(properties, "msgSelection", roleProperties.optString("websphere.mqtopicconnectionfactory.msgselection", None));
  Util.addIfNotNone(properties, "compressPayload", roleProperties.optString("websphere.mqtopicconnectionfactory.compresspayload", None));
  Util.addIfNotNone(properties, "wmqServerSvrconnChannel", roleProperties.optString("websphere.mqtopicconnectionfactory.wmqserversvrconnchannel", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.mqtopicconnectionfactory.providertype", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.mqtopicconnectionfactory.host", None));
  Util.addIfNotNone(properties, "statRefreshInterval", roleProperties.optString("websphere.mqtopicconnectionfactory.statrefreshinterval", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.mqtopicconnectionfactory.category", None));
  Util.addIfNotNone(properties, "multicast", roleProperties.optString("websphere.mqtopicconnectionfactory.multicast", None));
  print "Creating MQTopicConnectionFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MQTopicConnectionFactory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereConnectionPool":
        poolname = curjsonobject.getString("name");
        if poolname == "ConnectionPool":
          ConnectionPool.create(objid, curjsonobject, "connectionPool");
        elif poolname == "SessionPool":
          ConnectionPool.create(objid, curjsonobject, "sessionPool");
        else:
          ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQTopicConnectionFactory');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MQTopicConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQTopicConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqtopicconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqtopicconnectionfactory.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.wmqserverendpoint", None), "wmqServerEndpoint","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.secexit", None), "secExit","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.pubsubcleanupinterval", None), "pubSubCleanupInterval","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.description", None), "description","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.providerversion", None), "providerVersion","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.brokerccsubq", None), "brokerCCSubQ","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.wildcardformat", None), "wildcardFormat","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.logmissingtransactioncontext", None), "logMissingTransactionContext","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sslconfiguration", None), "sslConfiguration","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.diagnoseconnectionusage", None), "diagnoseConnectionUsage","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sslpeername", None), "sslPeerName","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sparsesubscriptions", None), "sparseSubscriptions","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.ccdturl", None), "ccdtUrl","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.publishackinterval", None), "publishAckInterval","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.failifquiesce", None), "failIfQuiesce","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.rcvexit", None), "rcvExit","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.proxyhostname", None), "proxyHostName","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sslcrl", None), "sslCRL","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.clientid", None), "clientID","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.brokercontrolqueue", None), "brokerControlQueue","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.ccsid", None), "CCSID","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.proxyport", None), "proxyPort","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.port", None), "port","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.brokerpubqueue", None), "brokerPubQueue","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sslresetcount", None), "sslResetCount","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sendexit", None), "sendExit","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.wmqservername", None), "wmqServerName","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.authmechanismpreference", None), "authMechanismPreference","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.clonesupport", None), "cloneSupport","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.xaenabled", None), "XAEnabled","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.authdataalias", None), "authDataAlias","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.pollinginterval", None), "pollingInterval","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.rescaninterval", None), "rescanInterval","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.jndiname", None), "jndiName","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.directauth", None), "directAuth","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sendexitinitdata", None), "sendExitInitData","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.brokerqueuemanager", None), "brokerQueueManager","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.qmgrtype", None), "qmgrType","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.queuemanager", None), "queueManager","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.sslciphersuite", None), "sslCipherSuite","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.inheritrrscontext", "false"), "inheritRRSContext","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.rcvexitinitdata", None), "rcvExitInitData","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.localaddress", None), "localAddress","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.name", None), "name","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.temptopicprefix", None), "tempTopicPrefix","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.xarecoveryauthalias", None), "xaRecoveryAuthAlias","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.transporttype", None), "transportType","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.brokersubqueue", None), "brokerSubQueue","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.clientreconnectoptions", "DISABLED"), "clientReconnectOptions","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.ssltype", None), "sslType","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.compressheaders", None), "compressHeaders","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.channel", None), "channel","MQTopicConnectionFactory");
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.mqtopicconnectionfactory.connamelist"):
    Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.connamelist", ""), "connameList","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.maxbatchsize", None), "maxBatchSize","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.clientreconnecttimeout", "1800"), "clientReconnectTimeout","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.brokerversion", None), "brokerVersion","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.useconnectionpooling", None), "useConnectionPooling","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.pubsubcleanup", None), "pubSubCleanup","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.managecachedhandles", None), "manageCachedHandles","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.tempmodel", None), "tempModel","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.substore", None), "substore","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.secexitinitdata", None), "secExitInitData","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.msgselection", None), "msgSelection","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.compresspayload", None), "compressPayload","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.wmqserversvrconnchannel", None), "wmqServerSvrconnChannel","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.providertype", None), "providerType","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.host", None), "host","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.statrefreshinterval", None), "statRefreshInterval","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.category", None), "category","MQTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopicconnectionfactory.multicast", None), "multicast","MQTopicConnectionFactory");
  if len(atts) != 0:
    print "Modifying MQTopicConnectionFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MQTopicConnectionFactory configuration up to date.";

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'MQTopicConnectionFactory');
  if connPool is not None and len(connPool) > 0:
    Util.remove(connPool);

  sessPool = Util.getOptionalAttribute(objid, 'sessionPool', 'MQTopicConnectionFactory');
  if sessPool is not None and len(sessPool) > 0:
    Util.remove(sessPool);

  mapping = Util.getOptionalAttribute(objid, 'mapping', 'MQTopicConnectionFactory');
  if mapping is not None and len(mapping) > 0:
    Util.remove(mapping);

  Property.removeProperties(objid, 'properties',"MQTopicConnectionFactory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereConnectionPool":
        poolname = curjsonobject.getString("name");
        if poolname == "ConnectionPool":
          ConnectionPool.create(objid, curjsonobject, "connectionPool");
        elif poolname == "SessionPool":
          ConnectionPool.create(objid, curjsonobject, "sessionPool");
        else:
          ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('MQTopicConnectionFactory');
