from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQLinkSenderChannelLocalizationPointRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQLinkSenderChannelLocalizationPointRef");
  exportedObject.put("roleName", "WebSphereSIBMQLinkSenderChannelLocalizationPointRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannellocalizationpointref.identifier", objid, "identifier","SIBMQLinkSenderChannelLocalizationPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQLinkSenderChannelLocalizationPointRef');
  return result;

def create(parentid, jsonobject, parentAtt, sibmessagingengineconpath):
  Util.pushPathElement('SIBMQLinkSenderChannelLocalizationPointRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkSenderChannelLocalizationPointRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.sibmqlinksenderchannellocalizationpointref.identifier'):
    raise Exception("SIBMQLinkSenderChannelLocalizationPointRef resource has property named websphere.sibmqlinksenderchannellocalizationpointref.identifier!");

  identifier = roleProperties.getString('websphere.sibmqlinksenderchannellocalizationpointref.identifier')
  
  refLocalizationPoint = None;
  localizationPointIds = Util.getid("%(conpath)sSIBMQLinkSenderChannelLocalizationPoint:/" % {'conpath': sibmessagingengineconpath }).splitlines();
  if len(localizationPointIds) > 0:
    for localizationPointId in localizationPointIds:
      if len(localizationPointId) > 0:
        lpidentifier = Util.getRequiredAttribute(localizationPointId, "identifier", "SIBMQLinkSenderChannelLocalizationPoint" );
        
        if (identifier == lpidentifier):
          refLocalizationPoint = localizationPointId;

  if (refLocalizationPoint != None):
    properties = [];
    properties.append([parentAtt, refLocalizationPoint]);
    Log.debug(properties);
    Log.debug(parentid);
    Log.log("Creating SIBMQLinkSenderChannelLocalizationPointRef to %(id)s for attribute %(att)s" % { 'id': refLocalizationPoint, 'att': parentAtt } );
    objid = Util.modify(parentid, properties);
    Log.debug("Finished Creating SIBMQLinkSenderChannelLocalizationPointRef to %(id)s for attribute %(att)s" % { 'id': refLocalizationPoint, 'att': parentAtt } );
  else:
    Log.log("Unable to locate reference SIBMQLinkSenderChannelLocalizationPoint for %(parent)s" % { 'parent': parentid} );
  Util.popPathElement('SIBMQLinkSenderChannelLocalizationPointRef');
