from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('BridgeInterface')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereBridgeInterface");
  exportedObject.put("roleName", "WebSphereBridgeInterface");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.bridgeinterface.chain", objid, "chain","BridgeInterface");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.bridgeinterface.node", objid, "node","BridgeInterface");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.bridgeinterface.server", objid, "server","BridgeInterface");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"BridgeInterface");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('BridgeInterface');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('BridgeInterface')
  if not jsonobject.has("roleProperties"):
    raise Exception("BridgeInterface resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "chain", roleProperties.optString("websphere.bridgeinterface.chain", None));
  Util.addIfNotNone(properties, "node", roleProperties.optString("websphere.bridgeinterface.node", None));
  Util.addIfNotNone(properties, "server", roleProperties.optString("websphere.bridgeinterface.server", None));
  print "Creating BridgeInterface with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("BridgeInterface", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('BridgeInterface');


def update(objid,jsonobject):
  Util.pushPathElement('BridgeInterface')
  if not jsonobject.has("roleProperties"):
    raise Exception("BridgeInterface resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.bridgeinterface.chain", None), "chain","BridgeInterface");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.bridgeinterface.node", None), "node","BridgeInterface");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.bridgeinterface.server", None), "server","BridgeInterface");
  if len(atts) != 0:
    print "Modifying BridgeInterface with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "BridgeInterface configuration up to date.";

  Property.removeProperties(objid, 'properties',"BridgeInterface");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('BridgeInterface');
