###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ConfigProperty import ConfigProperty

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConnectionDefinition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConnectionDefinition");
  exportedObject.put("roleName", "WebSphereConnectionDefinition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiondefinition.connectionfactoryinterface", objid, "connectionFactoryInterface","ConnectionDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiondefinition.connectionimplclass", objid, "connectionImplClass","ConnectionDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiondefinition.connectioninterface", objid, "connectionInterface","ConnectionDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiondefinition.connectionfactoryimplclass", objid, "connectionFactoryImplClass","ConnectionDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectiondefinition.managedconnectionfactoryclass", objid, "managedConnectionFactoryClass","ConnectionDefinition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  properties = Util.parseConfigIdListAttribute(objid, 'configProperties', 'ConnectionDefinition');
  for prop in properties:
    if len(prop) > 0:
      returndict = Util.createTypeFolder(respath, "ConfigProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ConfigProperty._export(prop, currespath, "ConfigProperty%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConnectionDefinition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ConnectionDefinition')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionDefinition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "connectionFactoryInterface", roleProperties.optString("websphere.connectiondefinition.connectionfactoryinterface", None));
  Util.addIfNotNone(properties, "connectionImplClass", roleProperties.optString("websphere.connectiondefinition.connectionimplclass", None));
  Util.addIfNotNone(properties, "connectionInterface", roleProperties.optString("websphere.connectiondefinition.connectioninterface", None));
  Util.addIfNotNone(properties, "connectionFactoryImplClass", roleProperties.optString("websphere.connectiondefinition.connectionfactoryimplclass", None));
  Util.addIfNotNone(properties, "managedConnectionFactoryClass", roleProperties.optString("websphere.connectiondefinition.managedconnectionfactoryclass", None));
  print "Creating ConnectionDefinition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ConnectionDefinition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereConfigProperty":
        ConfigProperty.create(objid, curjsonobject);
  Util.popPathElement('ConnectionDefinition');

def update(objid,jsonobject):
  Util.pushPathElement('ConnectionDefinition')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionDefinition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiondefinition.connectionfactoryinterface", None), "connectionFactoryInterface","ConnectionDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiondefinition.connectionimplclass", None), "connectionImplClass","ConnectionDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiondefinition.connectioninterface", None), "connectionInterface","ConnectionDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiondefinition.connectionfactoryimplclass", None), "connectionFactoryImplClass","ConnectionDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectiondefinition.managedconnectionfactoryclass", None), "managedConnectionFactoryClass","ConnectionDefinition");
  if len(atts) != 0:
    print "Modifying ConnectionDefinition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConnectionDefinition configuration up to date.";

  properties = Util.parseConfigIdListAttribute(objid, 'configProperties', 'ConnectionDefinition');
  for prop in properties:
    if len(prop) > 0:
      Util.remove(prop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereConfigProperty":
        ConfigProperty.create(objid, curjsonobject);
  Util.popPathElement('ConnectionDefinition');
