from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('IdentityAssertionTypeAssociation')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIdentityAssertionTypeAssociation");
  exportedObject.put("roleName", "WebSphereIdentityAssertionTypeAssociation");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identityassertiontypeassociation.type", objid, "type","IdentityAssertionTypeAssociation");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('IdentityAssertionTypeAssociation');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('IdentityAssertionTypeAssociation')
  if not jsonobject.has("roleProperties"):
    raise Exception("IdentityAssertionTypeAssociation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.identityassertiontypeassociation.type", None));
  print "Creating IdentityAssertionTypeAssociation with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("IdentityAssertionTypeAssociation", parentid, properties);
  Util.popPathElement('IdentityAssertionTypeAssociation');

def update(objid,jsonobject):
  Util.pushPathElement('IdentityAssertionTypeAssociation')
  if not jsonobject.has("roleProperties"):
    raise Exception("IdentityAssertionTypeAssociation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identityassertiontypeassociation.type", None), "type","IdentityAssertionTypeAssociation");
  if len(atts) != 0:
    print "Modifying IdentityAssertionTypeAssociation with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "IdentityAssertionTypeAssociation configuration up to date.";

  Util.popPathElement('IdentityAssertionTypeAssociation');
