from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MQFAPInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'MQFAPInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMQFAPInboundChannel");
  exportedObject.put("roleName", "WebSphereMQFAPInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqfapinboundchannel.name", objid, "name","MQFAPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqfapinboundchannel.discriminationweight", objid, "discriminationWeight","MQFAPInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MQFAPInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MQFAPInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MQFAPInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQFAPInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mqfapinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.mqfapinboundchannel.discriminationweight", None));
  print "Creating MQFAPInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MQFAPInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQFAPInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MQFAPInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQFAPInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqfapinboundchannel.name", None), "name","MQFAPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqfapinboundchannel.discriminationweight", None), "discriminationWeight","MQFAPInboundChannel");
  if len(atts) != 0:
    print "Modifying MQFAPInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MQFAPInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"MQFAPInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQFAPInboundChannel');
