from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIPProxyServerSettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIPProxyServerSettings");
  exportedObject.put("roleName", "WebSphereSIPProxyServerSettings");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxyserversettings.serverudpinterface", objid, "serverUDPInterface","SIPProxyServerSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxyserversettings.serverudpport", objid, "serverUDPPort","SIPProxyServerSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxyserversettings.servertlsinterface", objid, "serverTLSInterface","SIPProxyServerSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxyserversettings.servertcpinterface", objid, "serverTCPInterface","SIPProxyServerSettings");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIPProxyServerSettings');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIPProxyServerSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPProxyServerSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "serverUDPInterface", roleProperties.optString("websphere.sipproxyserversettings.serverudpinterface", None));
  Util.addIfNotNone(properties, "serverUDPPort", roleProperties.optString("websphere.sipproxyserversettings.serverudpport", None));
  Util.addIfNotNone(properties, "serverTLSInterface", roleProperties.optString("websphere.sipproxyserversettings.servertlsinterface", None));
  Util.addIfNotNone(properties, "serverTCPInterface", roleProperties.optString("websphere.sipproxyserversettings.servertcpinterface", None));
  print "Creating SIPProxyServerSettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIPProxyServerSettings", parentid, properties);
  Util.popPathElement('SIPProxyServerSettings');

def update(objid,jsonobject):
  Util.pushPathElement('SIPProxyServerSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPProxyServerSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxyserversettings.serverudpinterface", None), "serverUDPInterface","SIPProxyServerSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxyserversettings.serverudpport", None), "serverUDPPort","SIPProxyServerSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxyserversettings.servertlsinterface", None), "serverTLSInterface","SIPProxyServerSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxyserversettings.servertcpinterface", None), "serverTCPInterface","SIPProxyServerSettings");
  if len(atts) != 0:
    print "Modifying SIPProxyServerSettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIPProxyServerSettings configuration up to date.";

  Util.popPathElement('SIPProxyServerSettings');
