from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ServerInstance')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServerInstance");
  exportedObject.put("roleName", "WebSphereServerInstance");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serverinstance.maximumnumberofinstances", objid, "maximumNumberOfInstances","ServerInstance");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serverinstance.minimumnumofinstances", objid, "minimumNumOfInstances","ServerInstance");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serverinstance.enablemultipleserverinstances", objid, "enableMultipleServerInstances","ServerInstance");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServerInstance');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ServerInstance')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerInstance resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maximumNumberOfInstances", roleProperties.optString("websphere.serverinstance.maximumnumberofinstances", None));
  Util.addIfNotNone(properties, "minimumNumOfInstances", roleProperties.optString("websphere.serverinstance.minimumnumofinstances", None));
  Util.addIfNotNone(properties, "enableMultipleServerInstances", roleProperties.optString("websphere.serverinstance.enablemultipleserverinstances", None));
  print "Creating ServerInstance with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServerInstance", parentid, properties);
  Util.popPathElement('ServerInstance');

def update(objid,jsonobject):
  Util.pushPathElement('ServerInstance')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerInstance resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serverinstance.maximumnumberofinstances", None), "maximumNumberOfInstances","ServerInstance");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serverinstance.minimumnumofinstances", None), "minimumNumOfInstances","ServerInstance");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serverinstance.enablemultipleserverinstances", None), "enableMultipleServerInstances","ServerInstance");
  if len(atts) != 0:
    print "Modifying ServerInstance with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServerInstance configuration up to date.";

  Util.popPathElement('ServerInstance');
