from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TivoliPerfViewer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTivoliPerfViewer");
  exportedObject.put("roleName", "WebSphereTivoliPerfViewer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tivoliperfviewer.maxlogfiles", objid, "maxLogFiles","TivoliPerfViewer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tivoliperfviewer.inactivitytimeout", objid, "inactivityTimeout","TivoliPerfViewer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tivoliperfviewer.bufferlength", objid, "bufferLength","TivoliPerfViewer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tivoliperfviewer.logfilesize", objid, "logFileSize","TivoliPerfViewer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tivoliperfviewer.pollinginterval", objid, "pollingInterval","TivoliPerfViewer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tivoliperfviewer.loggingduration", objid, "loggingDuration","TivoliPerfViewer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TivoliPerfViewer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TivoliPerfViewer')
  if not jsonobject.has("roleProperties"):
    raise Exception("TivoliPerfViewer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxLogFiles", roleProperties.optString("websphere.tivoliperfviewer.maxlogfiles", None));
  Util.addIfNotNone(properties, "inactivityTimeout", roleProperties.optString("websphere.tivoliperfviewer.inactivitytimeout", None));
  Util.addIfNotNone(properties, "bufferLength", roleProperties.optString("websphere.tivoliperfviewer.bufferlength", None));
  Util.addIfNotNone(properties, "logFileSize", roleProperties.optString("websphere.tivoliperfviewer.logfilesize", None));
  Util.addIfNotNone(properties, "pollingInterval", roleProperties.optString("websphere.tivoliperfviewer.pollinginterval", None));
  Util.addIfNotNone(properties, "loggingDuration", roleProperties.optString("websphere.tivoliperfviewer.loggingduration", None));
  print "Creating TivoliPerfViewer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TivoliPerfViewer", parentid, properties);
  Util.popPathElement('TivoliPerfViewer');

def update(objid,jsonobject):
  Util.pushPathElement('TivoliPerfViewer')
  if not jsonobject.has("roleProperties"):
    raise Exception("TivoliPerfViewer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tivoliperfviewer.maxlogfiles", None), "maxLogFiles","TivoliPerfViewer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tivoliperfviewer.inactivitytimeout", None), "inactivityTimeout","TivoliPerfViewer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tivoliperfviewer.bufferlength", None), "bufferLength","TivoliPerfViewer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tivoliperfviewer.logfilesize", None), "logFileSize","TivoliPerfViewer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tivoliperfviewer.pollinginterval", None), "pollingInterval","TivoliPerfViewer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tivoliperfviewer.loggingduration", None), "loggingDuration","TivoliPerfViewer");
  if len(atts) != 0:
    print "Modifying TivoliPerfViewer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TivoliPerfViewer configuration up to date.";

  Util.popPathElement('TivoliPerfViewer');
