from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBContextInfo import SIBContextInfo;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBDestinationMediation')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBDestinationMediation");
  exportedObject.put("roleName", "WebSphereSIBDestinationMediation");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.uuid", objid, "uuid","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.selector", objid, "selector","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.discriminator", objid, "discriminator","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.allowconcurrentmediation", objid, "allowConcurrentMediation","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.globaltransaction", objid, "globalTransaction","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.mediationname", objid, "mediationName","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.description", objid, "description","SIBDestinationMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediation.handlerlistname", objid, "handlerListName","SIBDestinationMediation");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  contextInfos = Util.parseConfigIdListAttribute(objid, 'contextInfo', 'SIBDestinationMediation');
  for contextInfo in contextInfos:
    if len(contextInfo) > 0:
      returndict = Util.createTypeFolder(respath, "SIBContextInfo", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBContextInfo._export(contextInfo, currespath, "SIBContextInfo%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBDestinationMediation');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBDestinationMediation')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationMediation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibdestinationmediation.uuid", None));
  Util.addIfNotNone(properties, "selector", roleProperties.optString("websphere.sibdestinationmediation.selector", None));
  Util.addIfNotNone(properties, "discriminator", roleProperties.optString("websphere.sibdestinationmediation.discriminator", None));
  Util.addIfNotNone(properties, "allowConcurrentMediation", roleProperties.optString("websphere.sibdestinationmediation.allowconcurrentmediation", None));
  Util.addIfNotNone(properties, "globalTransaction", roleProperties.optString("websphere.sibdestinationmediation.globaltransaction", None));
  Util.addIfNotNone(properties, "mediationName", roleProperties.optString("websphere.sibdestinationmediation.mediationname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibdestinationmediation.description", None));
  Util.addIfNotNone(properties, "handlerListName", roleProperties.optString("websphere.sibdestinationmediation.handlerlistname", None));
  print "Creating SIBDestinationMediation with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBDestinationMediation", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBContextInfo":
        SIBContextInfo.create(objid, curjsonobject);

  Util.popPathElement('SIBDestinationMediation');

def update(objid,jsonobject):
  Util.pushPathElement('SIBDestinationMediation')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationMediation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.uuid", None), "uuid","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.selector", None), "selector","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.discriminator", None), "discriminator","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.allowconcurrentmediation", None), "allowConcurrentMediation","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.globaltransaction", None), "globalTransaction","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.mediationname", None), "mediationName","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.description", None), "description","SIBDestinationMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediation.handlerlistname", None), "handlerListName","SIBDestinationMediation");
  if len(atts) != 0:
    print "Modifying SIBDestinationMediation with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBDestinationMediation configuration up to date.";

  contextInfos = Util.parseConfigIdListAttribute(objid, 'contextInfo', 'SIBDestinationMediation');
  for contextInfo in contextInfos:
    if len(contextInfo) > 0:
      Util.remove(contextInfo);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBContextInfo":
        SIBContextInfo.create(objid, curjsonobject);

  Util.popPathElement('SIBDestinationMediation');
