import sys;
import os;

# Log levels, higher numbers produce more verbose logging
LogLevelOff = int(0);
LogLevelError = int(1);
LogLevelWarn = int(2);
LogLevelInfo = int(3);
LogLevelDebug = int(4);
LogLevelTrace = int(5);

__WASConfLogLevel__ = LogLevelInfo;
__WASConfLogFile__ = None;
__WASRedoLogFile__ = None;

def logMsg(message, logLevel=LogLevelInfo):
  Log = sys.modules[__name__]
  if Log.__WASConfLogLevel__ >= logLevel:
    if Log.__WASConfLogFile__ is not None:
      Log.__WASConfLogFile__.write("%s\n" % message);
      Log.__WASConfLogFile__.flush();
    else:
      print "Call to Log.logMsg before logFile initialized";

def log(message):
  Log = sys.modules[__name__]
  if Log.__WASConfLogLevel__ >= LogLevelInfo:
    print message;
    debug(message);

def redo(message):
  Log = sys.modules[__name__]
  # Don't emit redoLog unless we are at Debug level or higher
  if Log.__WASConfLogLevel__ >= LogLevelDebug:
    if Log.__WASRedoLogFile__ is not None:
      Log.__WASRedoLogFile__.write("%s\n" % message);
      Log.__WASRedoLogFile__.flush();
    else:
      print "Call to Log.redo before logFile initialized";

def debug(message):
  Log = sys.modules[__name__]
  if Log.__WASConfLogLevel__ >= LogLevelDebug:
    if Log.__WASConfLogFile__ is not None:
      Log.__WASConfLogFile__.write("%s\n" % message);
      Log.__WASConfLogFile__.flush();
    else:
      print "Call to Log.debug before logFile initialized";

def setLogLevel(logLevel):
  Log = sys.modules[__name__]
  Log.__WASConfLogLevel__ = int(logLevel);
  print "Logging level set to %d" % Log.__WASConfLogLevel__;

def setLogFile(file):
  Log = sys.modules[__name__]
  if Log.__WASConfLogFile__ is None:
    Log.__WASConfLogFile__ = file;
    #print "Log file set to %s" % Log.__WASConfLogFile__;
  else:
    print "Log file already set to %s" % Log.__WASConfLogFile__;

def setRedoFile(file):
  Log = sys.modules[__name__]
  if Log.__WASRedoLogFile__ is None:
    Log.__WASRedoLogFile__ = file;
  else:
    print "Log file already set to %s" % Log.__WASRedoLogFile__;

