from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('InvalidationSchedule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereInvalidationSchedule");
  exportedObject.put("roleName", "WebSphereInvalidationSchedule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.invalidationschedule.secondhour", objid, "secondHour","InvalidationSchedule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.invalidationschedule.firsthour", objid, "firstHour","InvalidationSchedule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('InvalidationSchedule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('InvalidationSchedule')
  if not jsonobject.has("roleProperties"):
    raise Exception("InvalidationSchedule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "secondHour", roleProperties.optString("websphere.invalidationschedule.secondhour", None));
  Util.addIfNotNone(properties, "firstHour", roleProperties.optString("websphere.invalidationschedule.firsthour", None));
  print "Creating InvalidationSchedule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("InvalidationSchedule", parentid, properties);
  Util.popPathElement('InvalidationSchedule');

def update(objid,jsonobject):
  Util.pushPathElement('InvalidationSchedule')
  if not jsonobject.has("roleProperties"):
    raise Exception("InvalidationSchedule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.invalidationschedule.secondhour", None), "secondHour","InvalidationSchedule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.invalidationschedule.firsthour", None), "firstHour","InvalidationSchedule");
  if len(atts) != 0:
    print "Modifying InvalidationSchedule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "InvalidationSchedule configuration up to date.";

  Util.popPathElement('InvalidationSchedule');
