from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBLocalizationPointRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBLocalizationPointRef");
  exportedObject.put("roleName", "WebSphereSIBLocalizationPointRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpointref.cluster", objid, "cluster","SIBLocalizationPointRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpointref.node", objid, "node","SIBLocalizationPointRef");
  #Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpointref.engineuuid", objid, "engineUuid","SIBLocalizationPointRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpointref.server", objid, "server","SIBLocalizationPointRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblocalizationpointref.mqserver", objid, "mqServer","SIBLocalizationPointRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBLocalizationPointRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBLocalizationPointRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBLocalizationPointRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cluster", roleProperties.optString("websphere.siblocalizationpointref.cluster", None));
  Util.addIfNotNone(properties, "node", roleProperties.optString("websphere.siblocalizationpointref.node", None));
  Util.addIfNotNone(properties, "engineUuid", roleProperties.optString("websphere.siblocalizationpointref.engineuuid", None));
  Util.addIfNotNone(properties, "server", roleProperties.optString("websphere.siblocalizationpointref.server", None));
  Util.addIfNotNone(properties, "mqServer", roleProperties.optString("websphere.siblocalizationpointref.mqserver", None));
  print "Creating SIBLocalizationPointRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBLocalizationPointRef", parentid, properties);
  Util.popPathElement('SIBLocalizationPointRef');

def update(objid,jsonobject):
  Util.pushPathElement('SIBLocalizationPointRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBLocalizationPointRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpointref.cluster", None), "cluster","SIBLocalizationPointRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpointref.node", None), "node","SIBLocalizationPointRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpointref.engineuuid", None), "engineUuid","SIBLocalizationPointRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpointref.server", None), "server","SIBLocalizationPointRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblocalizationpointref.mqserver", None), "mqServer","SIBLocalizationPointRef");
  if len(atts) != 0:
    print "Modifying SIBLocalizationPointRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBLocalizationPointRef configuration up to date.";

  Util.popPathElement('SIBLocalizationPointRef');
