from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WorkloadManagementPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkloadManagementPolicy");
  exportedObject.put("roleName", "WebSphereWorkloadManagementPolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadmanagementpolicy.availabilitymonitortimeout", objid, "availabilityMonitorTimeout","WorkloadManagementPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadmanagementpolicy.loadbalancingalgorithm", objid, "loadBalancingAlgorithm","WorkloadManagementPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadmanagementpolicy.advisoruri", objid, "advisorURI","WorkloadManagementPolicy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkloadManagementPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkloadManagementPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkloadManagementPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "availabilityMonitorTimeout", roleProperties.optString("websphere.workloadmanagementpolicy.availabilitymonitortimeout", None));
  Util.addIfNotNone(properties, "loadBalancingAlgorithm", roleProperties.optString("websphere.workloadmanagementpolicy.loadbalancingalgorithm", None));
  Util.addIfNotNone(properties, "advisorURI", roleProperties.optString("websphere.workloadmanagementpolicy.advisoruri", None));
  print "Creating WorkloadManagementPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkloadManagementPolicy", parentid, properties);
  Util.popPathElement('WorkloadManagementPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('WorkloadManagementPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkloadManagementPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadmanagementpolicy.availabilitymonitortimeout", None), "availabilityMonitorTimeout","WorkloadManagementPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadmanagementpolicy.loadbalancingalgorithm", None), "loadBalancingAlgorithm","WorkloadManagementPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadmanagementpolicy.advisoruri", None), "advisorURI","WorkloadManagementPolicy");
  if len(atts) != 0:
    print "Modifying WorkloadManagementPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkloadManagementPolicy configuration up to date.";

  Util.popPathElement('WorkloadManagementPolicy');
