from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ClientSecurityProperties')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClientSecurityProperties");
  exportedObject.put("roleName", "WebSphereClientSecurityProperties");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientsecurityproperties.authenticationretrycount", objid, "authenticationRetryCount","ClientSecurityProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientsecurityproperties.securityenabled", objid, "securityEnabled","ClientSecurityProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientsecurityproperties.credentialgeneratorprops", objid, "credentialGeneratorProps","ClientSecurityProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientsecurityproperties.credentialgeneratorclass", objid, "credentialGeneratorClass","ClientSecurityProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientsecurityproperties.credentialauthentication", objid, "credentialAuthentication","ClientSecurityProperties");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ClientSecurityProperties');
  return result;



def create(parentid, jsonobject):
  if not Util.isValidType("ClientSecurityProperties", 1):
    return;
  Util.pushPathElement('ClientSecurityProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClientSecurityProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "authenticationRetryCount", roleProperties.optString("websphere.clientsecurityproperties.authenticationretrycount", None));
  Util.addIfNotNone(properties, "securityEnabled", roleProperties.optString("websphere.clientsecurityproperties.securityenabled", None));
  Util.addIfNotNone(properties, "credentialGeneratorProps", roleProperties.optString("websphere.clientsecurityproperties.credentialgeneratorprops", None));
  Util.addIfNotNone(properties, "credentialGeneratorClass", roleProperties.optString("websphere.clientsecurityproperties.credentialgeneratorclass", None));
  Util.addIfNotNone(properties, "credentialAuthentication", roleProperties.optString("websphere.clientsecurityproperties.credentialauthentication", None));
  print "Creating ClientSecurityProperties with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ClientSecurityProperties", parentid, properties);
  Util.popPathElement('ClientSecurityProperties');

def update(objid,jsonobject):
  Util.pushPathElement('ClientSecurityProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClientSecurityProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientsecurityproperties.authenticationretrycount", None), "authenticationRetryCount","ClientSecurityProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientsecurityproperties.securityenabled", None), "securityEnabled","ClientSecurityProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientsecurityproperties.credentialgeneratorprops", None), "credentialGeneratorProps","ClientSecurityProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientsecurityproperties.credentialgeneratorclass", None), "credentialGeneratorClass","ClientSecurityProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientsecurityproperties.credentialauthentication", None), "credentialAuthentication","ClientSecurityProperties");
  if len(atts) != 0:
    print "Modifying ClientSecurityProperties with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ClientSecurityProperties configuration up to date.";

  Util.popPathElement('ClientSecurityProperties');
