from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthUser')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthUser");
  exportedObject.put("roleName", "WebSphereSIBAuthUser");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthuser.uniquename", objid, "uniqueName","SIBAuthUser");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthuser.identifier", objid, "identifier","SIBAuthUser");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthUser');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthUser')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthUser resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uniqueName", roleProperties.optString("websphere.sibauthuser.uniquename", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthuser.identifier", None));
  print "Creating SIBAuthUser with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthUser", parentid, properties);
  Util.popPathElement('SIBAuthUser');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthUser')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthUser resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthuser.uniquename", None), "uniqueName","SIBAuthUser");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthuser.identifier", None), "identifier","SIBAuthUser");
  if len(atts) != 0:
    print "Modifying SIBAuthUser with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthUser configuration up to date.";

  Util.popPathElement('SIBAuthUser');
