from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from ManagementScopeRef import ManagementScopeRef

__name_att__ = "websphere.trustmanager.name";

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TrustManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTrustManager");
  exportedObject.put("roleName", "WebSphereTrustManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.algorithm", objid, "algorithm","TrustManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.name", objid, "name","TrustManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.trustmanagerclass", objid, "trustManagerClass","TrustManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.provider", objid, "provider","TrustManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'additionalTrustManagerAttrs',"TrustManager","AdditionalTrustManagerAttrs");

  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'TrustManager');
  if managementScope is not None and len(managementScope) > 0:
    returndict = Util.createTypeFolder(respath, "ManagementScopeRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ManagementScopeRef._export(managementScope, currespath, "ManagementScope"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TrustManager');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("keystore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.trustmanager.name"):
    raise Exception("Resource role properties does not contain websphere.trustmanager.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create TrustManager on.");
      objid = create(parentid, jsonobject);
  else:
    # need to compare management scopes because there may be multiple TrustManagers with
    # the same name but different scope.
    if jsonobject.has('children'):
      childrenArray = jsonobject.getJSONArray('children');
      for curjsonobject in Util.getHighestChildrenWithRole(childrenArray):
        currole = curjsonobject.getString('roleName');
        if currole == "WebSphereManagementScopeRef":
          msRoleProperties = curjsonobject.getJSONObject("roleProperties");
          targetScopeName = msRoleProperties.optString("websphere.managementscoperef.scopename");
          break;

    # see if more than one were returned
    objIds = objid.splitlines();
    objectToUpdate = "";
    for id in objIds:
      # get management scope
      managementScope = Util.getRequiredAttribute(id, "managementScope", "TrustManager");
      scopeName = Util.getRequiredAttribute(managementScope, "scopeName", "ManagementScope");
      if scopeName == targetScopeName:
        objid = id;
        break;
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;

def doImportPartial(containmentpath, roleName, jsonobject):
  return doImport(containmentpath, roleName, jsonobject);

def create(parentid, jsonobject):
  Util.pushPathElement('TrustManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "algorithm", roleProperties.optString("websphere.trustmanager.algorithm", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.trustmanager.name", None));
  Util.addIfNotNone(properties, "trustManagerClass", roleProperties.optString("websphere.trustmanager.trustmanagerclass", None));
  Util.addIfNotNone(properties, "provider", roleProperties.optString("websphere.trustmanager.provider", None));
  print "Creating TrustManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TrustManager", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      attName = None;
      currpath = curjsonobject.getString('path');
      lastSlashIndex = currpath.rindex('/');
      nextToLastSlashIndex = currpath.rindex('/', 0, lastSlashIndex - 1);
      foldername = currpath[nextToLastSlashIndex+1:lastSlashIndex];
      if (foldername.find(Util.getTypeFoldername('AdditionalTrustManagerAttrs')) > -1):
        attName = 'additionalTrustManagerAttrs';
      propertObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole, attName);
      if (propertyObject == 0):
        if currole == "WebSphereManagementScopeRef":
          ManagementScopeRef.create(objid, curjsonobject, "managementScope");
  Util.popPathElement('TrustManager');

def update(objid,jsonobject):
  Util.pushPathElement('TrustManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.algorithm", None), "algorithm","TrustManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.name", None), "name","TrustManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.trustmanagerclass", None), "trustManagerClass","TrustManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.provider", None), "provider","TrustManager");
  if len(atts) != 0:
    print "Modifying TrustManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TrustManager configuration up to date.";

  Property.removeProperties(objid, 'additionalTrustManagerAttrs',"TrustManager");

  Util.unsetAttribute(objid, "managementScope", "TrustManager");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      attName = None;
      currpath = curjsonobject.getString('path');
      lastSlashIndex = currpath.rindex('/');
      nextToLastSlashIndex = currpath.rindex('/', 0, lastSlashIndex - 1);
      foldername = currpath[nextToLastSlashIndex+1:lastSlashIndex];
      if (foldername.find(Util.getTypeFoldername('AdditionalTrustManagerAttrs')) > -1):
        attName = 'additionalTrustManagerAttrs';
      propertObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole, attName);
      if (propertyObject == 0):
        if currole == "WebSphereManagementScopeRef":
          ManagementScopeRef.create(objid, curjsonobject, "managementScope");

  Util.popPathElement('TrustManager');
