from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASResourceRefExtension')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASResourceRefExtension");
  exportedObject.put("roleName", "WebSphereWASResourceRefExtension");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourcerefextension.connectionmanagementpolicy", objid, "connectionManagementPolicy","WASResourceRefExtension");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourcerefextension.isolationlevel", objid, "isolationLevel","WASResourceRefExtension");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourcerefextension.commitpriority", objid, "commitPriority","WASResourceRefExtension");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourcerefextension.branchcoupling", objid, "branchCoupling","WASResourceRefExtension");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASResourceRefExtension');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASResourceRefExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceRefExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "connectionManagementPolicy", roleProperties.optString("websphere.wasresourcerefextension.connectionmanagementpolicy", None));
  Util.addIfNotNone(properties, "isolationLevel", roleProperties.optString("websphere.wasresourcerefextension.isolationlevel", None));
  Util.addIfNotNone(properties, "commitPriority", roleProperties.optString("websphere.wasresourcerefextension.commitpriority", None));
  Util.addIfNotNone(properties, "branchCoupling", roleProperties.optString("websphere.wasresourcerefextension.branchcoupling", None));
  print "Creating WASResourceRefExtension with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASResourceRefExtension", parentid, properties);
  Util.popPathElement('WASResourceRefExtension');

def update(objid,jsonobject):
  Util.pushPathElement('WASResourceRefExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceRefExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourcerefextension.connectionmanagementpolicy", None), "connectionManagementPolicy","WASResourceRefExtension");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourcerefextension.isolationlevel", None), "isolationLevel","WASResourceRefExtension");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourcerefextension.commitpriority", None), "commitPriority","WASResourceRefExtension");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourcerefextension.branchcoupling", None), "branchCoupling","WASResourceRefExtension");
  if len(atts) != 0:
    print "Modifying WASResourceRefExtension with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASResourceRefExtension configuration up to date.";

  Util.popPathElement('WASResourceRefExtension');
