from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
import re;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Description')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDescription");
  exportedObject.put("roleName", "WebSphereDescription");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.description.value", objid, "value","Description");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.description.lang", objid, "lang","Description");

  #This is to filter out any strange extra whitespace characters such as \t and \n
  valueString = roleProperties.optString("websphere.description.value");
  valueString = re.sub('\s+', ' ', valueString);
  valueString = valueString.strip();
  roleProperties.put("websphere.description.value", valueString);

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Description');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Description')
  if not jsonobject.has("roleProperties"):
    raise Exception("Description resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.description.value", None));
  Util.addIfNotNone(properties, "lang", roleProperties.optString("websphere.description.lang", None));
  print "Creating Description with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Description", parentid, properties);
  Util.popPathElement('Description');

def update(objid,jsonobject):
  Util.pushPathElement('Description')
  if not jsonobject.has("roleProperties"):
    raise Exception("Description resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.description.value", None), "value","Description");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.description.lang", None), "lang","Description");
  if len(atts) != 0:
    print "Modifying Description with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "Description configuration up to date.";

  Util.popPathElement('Description');
